/*
 * Decompiled with CFR 0.152.
 */
package amida.node.comparator;

import amida.node.CallNode;
import amida.node.Node;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public abstract class NodeTreeComparator
implements Comparator {
    public static boolean compareNotEndedNode = false;
    int depth;

    public NodeTreeComparator(int depth) {
        this.depth = depth;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Node && o2 instanceof Node) {
            return this.compareNode((Node)o1, (Node)o2, this.depth);
        }
        if (o1 instanceof List && o2 instanceof List) {
            return this.compareList((List)o1, (List)o2, this.depth);
        }
        return 1;
    }

    private int compareNode(Node node1, Node node2, int depth) {
        if (depth == 0) {
            return 0;
        }
        boolean node1IsCallNode = node1 instanceof CallNode;
        boolean node2IsCallNode = node2 instanceof CallNode;
        if (node1IsCallNode && node2IsCallNode) {
            if (this.compare((CallNode)node1, (CallNode)node2) == 0) {
                return this.compareList(node1.getChildren(), node2.getChildren(), depth - 1);
            }
            return -1;
        }
        if (node1.getCallNodeNum() == node2.getCallNodeNum()) {
            if (node1IsCallNode) {
                return this.compareNode(node1, (Node)node2.getChildren().get(0), depth);
            }
            if (node2IsCallNode) {
                return this.compareNode((Node)node1.getChildren().get(0), node2, depth);
            }
            return this.compareList(node1.getChildren(), node2.getChildren(), depth);
        }
        return -1;
    }

    private int compareList(List list1, List list2, int depth) {
        if (depth == 0) {
            return 0;
        }
        ListIterator it1 = list1.listIterator();
        ListIterator it2 = list2.listIterator();
        while (it1.hasNext() && it2.hasNext()) {
            List subList;
            int length;
            int start;
            int callNodeNum2;
            Node node1 = (Node)it1.next();
            Node node2 = (Node)it2.next();
            int callNodeNum1 = node1.getCallNodeNum();
            if (callNodeNum1 == (callNodeNum2 = node2.getCallNodeNum())) {
                boolean node1IsCallNode = node1 instanceof CallNode;
                boolean node2IsCallNode = node2 instanceof CallNode;
                if (!(node1IsCallNode && node2IsCallNode ? this.compareNode(node1, node2, depth) != 0 : (node2IsCallNode ? this.compareNode((Node)node1.getChildren().get(0), node2, depth) != 0 : (node1IsCallNode ? this.compareNode(node1, (Node)node2.getChildren().get(0), depth) != 0 : this.compareList(node1.getChildren(), node2.getChildren(), depth) != 0)))) continue;
                return -1;
            }
            if (callNodeNum1 > callNodeNum2) {
                start = it2.nextIndex() - 1;
                length = 1;
                while (it2.hasNext() && callNodeNum1 > callNodeNum2) {
                    node2 = (Node)it2.next();
                    callNodeNum2 += node2.getCallNodeNum();
                    ++length;
                }
                subList = list2.subList(start, start + length);
                if (callNodeNum1 == callNodeNum2) {
                    if (this.compareList(node1.getChildren(), subList, depth) == 0) continue;
                    return -1;
                }
                return -1;
            }
            start = it1.nextIndex() - 1;
            length = 1;
            while (it1.hasNext() && callNodeNum1 < callNodeNum2) {
                node1 = (Node)it1.next();
                callNodeNum1 += node1.getCallNodeNum();
                ++length;
            }
            subList = list1.subList(start, start + length);
            if (callNodeNum1 == callNodeNum2) {
                if (this.compareList(subList, node2.getChildren(), depth) == 0) continue;
                return -1;
            }
            return -1;
        }
        if (!it1.hasNext() && !it2.hasNext()) {
            return 0;
        }
        return -1;
    }

    protected abstract int compare(CallNode var1, CallNode var2);
}

