/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler;

import amida.library.PromptManager;
import amida.library.PromptPrinterFrame;
import amida.library.ThreadEndListener;
import amida.profiler.Profiler;
import amida.profiler.ProfilerException;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class ProfileThread
extends Thread {
    private List endListeners = new LinkedList();
    private PromptManager prompt;
    private PromptPrinterFrame promptFrame;
    private File profiler;
    private File logDirectory;
    private File newCurrentDirectory;
    private String command;
    private List profilerInit;
    private List logFiles;

    public ProfileThread(File profiler, File logDirectory, String command, List profilerInit, File newCurrentDirectory, PromptManager prompt) {
        this.profiler = profiler;
        this.logDirectory = logDirectory;
        this.command = command;
        this.profilerInit = profilerInit;
        this.newCurrentDirectory = newCurrentDirectory;
        this.prompt = prompt;
    }

    public void addEndListener(ThreadEndListener listener) {
        this.endListeners.add(listener);
    }

    private void threadEnd() {
        Iterator it = this.endListeners.iterator();
        while (it.hasNext()) {
            ThreadEndListener listener = (ThreadEndListener)it.next();
            listener.threadEnd(this);
        }
    }

    public List getLogfiles() {
        return this.logFiles;
    }

    public void run() {
        try {
            this.logFiles = Profiler.profile(this.profiler, this.logDirectory, this.command, this.profilerInit, this.newCurrentDirectory, this.prompt);
        }
        catch (ProfilerException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Profile Error", 0);
        }
        this.threadEnd();
    }
}

