/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler;

import amida.library.PromptManager;
import amida.profiler.LogFile;
import amida.profiler.ProfilerException;
import amida.profiler.ProfilerPrompt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Profiler {
    public static final String COMMAND_TOP = "java -Xrunprofiler -Djava.compiler=NONE -Xdebug";
    public static final String JAR_OPTION = "-jar";
    public static final String MAX_HEAP_SIZE_OPTION = "-Xmx";
    public static final String JAR_EXTENSION = "jar";
    public static final String PROFILER_NAME = "profiler.dll";
    public static final String DEFAULT_CURRENT = String.valueOf(new File(".").getAbsoluteFile().getParentFile().getAbsolutePath()) + "\\";
    public static final String DEFAULT_LOG_DIRECTORY = String.valueOf(DEFAULT_CURRENT) + "log\\";

    public static List profile(File profiler, File logDirectory, String command, List init, File newCurrent, PromptManager prompt) throws ProfilerException {
        File prevCurrent = new File(".").getAbsoluteFile().getParentFile();
        if (!prevCurrent.equals(newCurrent)) {
            try {
                Process process = Runtime.getRuntime().exec("command.com /c cd " + newCurrent.getAbsolutePath());
            }
            catch (IOException e) {
                throw new ProfilerException("Can not move current directory.");
            }
        }
        File newProfiler = null;
        if (!profiler.getParentFile().equals(newCurrent)) {
            String os = System.getProperty("os.name");
            if (os.startsWith("Windows")) {
                try {
                    String copyCommand = "command.com /c copy " + profiler.getAbsolutePath() + " " + newCurrent.getAbsolutePath();
                    Process process = Runtime.getRuntime().exec(copyCommand);
                    process.waitFor();
                    newProfiler = new File(String.valueOf(newCurrent.getAbsolutePath()) + "\\profiler.dll");
                }
                catch (IOException e) {
                    throw new ProfilerException("Can not copy profiler.dll to " + newCurrent.getAbsolutePath());
                }
                catch (InterruptedException e) {
                    throw new ProfilerException("Can not copy profiler.dll to " + newCurrent.getAbsolutePath());
                }
            } else {
                throw new ProfilerException("Can not use this function on " + os + ".");
            }
        }
        File iniFile = new File(String.valueOf(newCurrent.getAbsolutePath()) + "\\" + "profiler.ini");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(iniFile));
            String lineSeparator = System.getProperty("line.separator");
            Iterator it = init.iterator();
            while (it.hasNext()) {
                bw.write(String.valueOf((String)it.next()) + lineSeparator);
            }
            bw.close();
        }
        catch (IOException e) {
            if (newProfiler != null && newProfiler.exists()) {
                newProfiler.delete();
            }
            throw new ProfilerException("Can not make profiler.ini at " + newCurrent.getAbsolutePath());
        }
        File[] prevFiles = logDirectory.listFiles();
        long[] updates = null;
        if (prevFiles != null) {
            updates = new long[prevFiles.length];
            int i = 0;
            while (i < prevFiles.length) {
                updates[i] = prevFiles[i].lastModified();
                ++i;
            }
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (prompt != null) {
                prompt.setStdOut(process.getInputStream());
                prompt.setStdErr(process.getErrorStream());
                ((ProfilerPrompt)prompt).start();
            }
            process.waitFor();
            if (newProfiler != null) {
                if (newProfiler.exists()) {
                    newProfiler.delete();
                }
                if (iniFile.exists()) {
                    iniFile.delete();
                }
            }
        }
        catch (InterruptedException e) {
            if (newProfiler != null && newProfiler.exists()) {
                newProfiler.delete();
            }
            throw new ProfilerException("Can not execution \"" + command + "\".");
        }
        catch (IOException e) {
            if (newProfiler != null && newProfiler.exists()) {
                newProfiler.delete();
            }
            throw new ProfilerException("Can not execution \"" + command + "\".");
        }
        File[] files = logDirectory.listFiles();
        ArrayList<LogFile> newLogFiles = new ArrayList<LogFile>();
        if (files == null) {
            throw new ProfilerException("Log file not found.");
        }
        if (prevFiles == null) {
            int i = 0;
            while (i < files.length) {
                newLogFiles.add(new LogFile(files[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < files.length) {
                boolean exist = false;
                int j = 0;
                while (j < prevFiles.length) {
                    if (files[i].getAbsolutePath().equals(prevFiles[j].getAbsolutePath())) {
                        exist = true;
                        if (files[i].lastModified() == updates[j]) break;
                        newLogFiles.add(new LogFile(files[i]));
                        break;
                    }
                    ++j;
                }
                if (!exist) {
                    newLogFiles.add(new LogFile(files[i]));
                }
                ++i;
            }
        }
        return newLogFiles;
    }
}

