/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler.gui;

import amida.profiler.gui.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MethodTableModel
extends AbstractTableModel {
    private List methods = new ArrayList();

    protected MethodTableModel() {
    }

    protected MethodTableModel(List methods) {
        this.methods.addAll(methods);
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public int getRowCount() {
        return this.methods.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Package";
        }
        if (column == 1) {
            return "Class";
        }
        if (column == 2) {
            return "Method";
        }
        return null;
    }

    public Object getValueAt(int arg0, int arg1) {
        if (arg0 < 0 || arg0 >= this.methods.size() || arg1 < 0 || arg1 > 2) {
            return null;
        }
        if (arg1 == 0) {
            return ((Method)this.methods.get(arg0)).getPackageName();
        }
        if (arg1 == 1) {
            return ((Method)this.methods.get(arg0)).getClassName();
        }
        if (arg1 == 2) {
            return ((Method)this.methods.get(arg0)).getMethodName();
        }
        return null;
    }

    public void add(Method method) {
        this.methods.add(method);
        this.fireTableDataChanged();
    }

    public void delete(int index) {
        if (index >= 0 && index < this.methods.size()) {
            this.methods.remove(index);
            this.fireTableDataChanged();
        }
    }

    public void set(int index, Method method) {
        if (index >= 0 && index < this.methods.size()) {
            this.methods.set(index, method);
            this.fireTableDataChanged();
        }
    }

    public int size() {
        return this.methods.size();
    }

    public List getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public Method getMethod(int index) {
        return (Method)this.methods.get(index);
    }
}

