/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler.gui;

import amida.library.CheckTextFieldPanel;
import amida.library.LineTextFieldPanel;
import amida.library.MyFileFilter;
import amida.library.ThreadEndListener;
import amida.profiler.ProfileThread;
import amida.profiler.Profiler;
import amida.profiler.ProfilerPrompt;
import amida.profiler.gui.LogChooser;
import amida.profiler.gui.LogChooserModel;
import amida.profiler.gui.Method;
import amida.profiler.gui.MethodTableModel;
import amida.sequencer.gui.InformationTabbedPane;
import amida.sequencer.gui.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ProfileDialog
extends JDialog {
    private static final int SMALL_TEXT_FIELD_SIZE = 40;
    private static final int LARGE_TEXT_FIELD_SIZE = 45;
    private static final String GET_FILTERED_METHOD = "GetFilteredMethod";
    private static final String LOG_FILE_DIRECTORY = "LogfileDirectory";
    private static final String PACKAGE_FILTER = "PackageFilter";
    private static final String CLASS_FILTER = "ClassFilter";
    private static final String METHOD_FILTER = "MethodFilter";
    private static final String START_METHOD = "StartMethod";
    private static final String[] classPathExtensions = new String[]{"jar", "zip"};
    private static final ProfileDialog singleton = new ProfileDialog();
    private final JTabbedPane tab = new JTabbedPane();
    private final JTextField commandField;
    private final List vmArgs = new LinkedList();
    private String mainFile = "";
    private final List args = new LinkedList();
    private String options = "";
    private final List classPathes = new LinkedList();
    private final JFrame owner;
    private final LogChooser logChooser;
    private final TargetPanel targetPanel = new TargetPanel();
    private final ProfilerPanel profilerPanel = new ProfilerPanel();
    private final VmOptionPanel vmOptionPanel = new VmOptionPanel();
    private final FilterPanel filterPanel = new FilterPanel();

    private ProfileDialog() {
        super(MainFrame.getInstance(), "Setting profiler option", true);
        this.owner = MainFrame.getInstance();
        this.logChooser = InformationTabbedPane.getInstance().getLogChooser();
        this.tab.setPreferredSize(new Dimension(600, 300));
        this.setDefaultCloseOperation(1);
        Container cp = this.getContentPane();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        cp.setLayout(gb);
        this.tab.add((Component)this.targetPanel, "target");
        this.tab.add((Component)this.profilerPanel, "profiler");
        this.tab.add((Component)this.vmOptionPanel, "vm option");
        this.tab.add((Component)this.filterPanel, "filter");
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new GridLayout(1, 1));
        commandPanel.setBorder(BorderFactory.createTitledBorder("Execute command"));
        this.commandField = new JTextField("java -Xrunprofiler -Djava.compiler=NONE -Xdebug", 40);
        this.commandField.setEditable(false);
        this.commandField.setBackground(Color.white);
        commandPanel.add(this.commandField);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton profileButton = new JButton("Profile");
        buttonPanel.add(profileButton);
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.add(cancelButton);
        cons.fill = 1;
        cons.gridwidth = 1;
        cons.gridheight = 3;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        gb.setConstraints(this.tab, cons);
        cp.add(this.tab);
        cons.gridheight = 1;
        cons.weighty = 0.0;
        cons.gridy = 3;
        gb.setConstraints(commandPanel, cons);
        cp.add(commandPanel);
        cons.gridy = 4;
        gb.setConstraints(buttonPanel, cons);
        cp.add(buttonPanel);
        profileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ProfileDialog.this.profile();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ProfileDialog.this.setVisible(false);
            }
        });
        this.commandField.setText(this.getCommand());
        this.commandField.repaint();
        this.pack();
    }

    public static ProfileDialog getInstance() {
        return singleton;
    }

    private void setMainFile(String fileName) {
        this.mainFile = fileName;
    }

    private void setEnabledMode(JTextField textArea) {
        textArea.setEnabled(true);
        textArea.setDisabledTextColor(Color.BLACK);
        textArea.setBackground(Color.WHITE);
    }

    private void setNonEnabledMode(JTextField textArea) {
        textArea.setEnabled(false);
        textArea.setDisabledTextColor(Color.GRAY);
        textArea.setBackground(Color.LIGHT_GRAY);
    }

    public String getCommand() {
        int index;
        String extension;
        StringBuffer buffer = new StringBuffer("java -Xrunprofiler -Djava.compiler=NONE -Xdebug ");
        buffer.append(String.valueOf(this.options) + " ");
        Iterator it = this.vmArgs.iterator();
        while (it.hasNext()) {
            buffer.append(String.valueOf((String)it.next()) + " ");
        }
        it = this.classPathes.iterator();
        String mainPackagePath = "";
        int mainPackagePathLength = 0;
        if (it.hasNext()) {
            buffer.append("-classpath ");
            while (it.hasNext()) {
                String classPath = (String)it.next();
                if (this.mainFile.startsWith(classPath)) {
                    String packagePath = this.mainFile.substring(classPath.length());
                    packagePath = packagePath.replace('\\', '.');
                    if (mainPackagePathLength == 0 || packagePath.length() < mainPackagePathLength) {
                        mainPackagePath = packagePath;
                        mainPackagePathLength = packagePath.length();
                    }
                }
                buffer.append(classPath);
                if (it.hasNext()) {
                    buffer.append(";");
                    continue;
                }
                buffer.append(" ");
            }
        }
        if ((extension = mainPackagePath.substring((index = mainPackagePath.lastIndexOf(".")) + 1)).equals("class")) {
            buffer.append(String.valueOf(mainPackagePath.substring(0, index)) + " ");
        } else {
            buffer.append(String.valueOf(this.mainFile) + " ");
        }
        if (this.mainFile != null && !this.mainFile.equals("")) {
            it = this.args.iterator();
            while (it.hasNext()) {
                buffer.append(String.valueOf((String)it.next()) + " ");
            }
        }
        return buffer.toString().trim();
    }

    private void profile() {
        File profiler = new File(this.profilerPanel.getProfiler().trim());
        if (!profiler.exists()) {
            JOptionPane.showMessageDialog(this, "profiler.dll not found.", "Profile Error", 0);
            return;
        }
        File current = new File(Profiler.DEFAULT_CURRENT);
        String temp = this.profilerPanel.getLogDirectory().trim();
        File logDirectory = !temp.equals("") ? new File(temp) : new File(Profiler.DEFAULT_CURRENT);
        ArrayList<String> init = new ArrayList<String>();
        init.add(new String("LogfileDirectory=" + logDirectory.getAbsolutePath()));
        if (this.filterPanel.recordFilteredMethods()) {
            init.add(new String("GetFilteredMethod=1"));
        } else {
            init.add(new String("GetFilteredMethod=0"));
        }
        Method startMethod = this.filterPanel.getStartMethod();
        if (startMethod != null) {
            init.add(new String("StartMethod=" + startMethod.toString()));
        }
        List filteredMethods = this.filterPanel.getFilteredMethods();
        Iterator it = filteredMethods.iterator();
        while (it.hasNext()) {
            Method filteredMethod = (Method)it.next();
            if (filteredMethod.getMethodName().equals("*")) {
                if (filteredMethod.getClassName().equals("*")) {
                    init.add("PackageFilter=" + filteredMethod.getPackageName());
                    continue;
                }
                init.add("ClassFilter=" + filteredMethod.getPackageName() + "." + filteredMethod.getClassName());
                continue;
            }
            init.add("MethodFilter=" + filteredMethod.toString());
        }
        InformationTabbedPane.getInstance().setSelectedIndex(InformationTabbedPane.getInstance().getPromptPriterIndex());
        ProfilerPrompt promptManager = new ProfilerPrompt(InformationTabbedPane.getInstance().getPromptPrinter());
        ProfileThread thread = new ProfileThread(profiler, logDirectory, this.getCommand(), init, current, promptManager);
        thread.addEndListener(new ThreadEndListener(){

            public void threadEnd(Thread thread) {
                ProfileDialog.this.profileEnd(((ProfileThread)thread).getLogfiles());
            }
        });
        thread.start();
        this.setVisible(false);
    }

    private void profileEnd(List logFiles) {
        if (this.logChooser != null && logFiles != null) {
            LogChooserModel model = (LogChooserModel)this.logChooser.getModel();
            model.setLogList(logFiles);
            Dimension size = new Dimension(this.logChooser.getRowHeight() * (logFiles.size() + 1), this.logChooser.getWidth());
            this.logChooser.setPreferredScrollableViewportSize(size);
            InformationTabbedPane.getInstance().setSelectedIndex(InformationTabbedPane.getInstance().getLogChooserIndex());
        }
    }

    public LogChooser getLogChooser() {
        return this.logChooser;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.owner);
        }
        super.setVisible(b);
    }

    static /* synthetic */ void access$0(ProfileDialog profileDialog, String string) {
        profileDialog.setMainFile(string);
    }

    static /* synthetic */ List access$1(ProfileDialog profileDialog) {
        return profileDialog.vmArgs;
    }

    static /* synthetic */ JTextField access$2(ProfileDialog profileDialog) {
        return profileDialog.commandField;
    }

    static /* synthetic */ List access$3(ProfileDialog profileDialog) {
        return profileDialog.args;
    }

    static /* synthetic */ void access$5(ProfileDialog profileDialog, String string) {
        profileDialog.options = string;
    }

    private class TargetPanel
    extends JPanel {
        private final JTextField mainFileField;
        private final JTextField argsField;

        TargetPanel() {
            LineTextFieldPanel mainFilePanel = new LineTextFieldPanel("");
            mainFilePanel.setBorder(BorderFactory.createTitledBorder("Main"));
            this.mainFileField = mainFilePanel.getTextField();
            JButton mainReferenceButton = new JButton("...");
            mainFilePanel.add(mainReferenceButton);
            LineTextFieldPanel argsPanel = new LineTextFieldPanel("");
            argsPanel.setBorder(BorderFactory.createTitledBorder("args"));
            this.argsField = argsPanel.getTextField();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 2;
            cons.anchor = 11;
            cons.gridx = 0;
            cons.weightx = 1.0;
            gb.setConstraints(mainFilePanel, cons);
            this.add(mainFilePanel);
            cons.weighty = 1.0;
            gb.setConstraints(argsPanel, cons);
            this.add(argsPanel);
            mainReferenceButton.addActionListener(new ActionListener(this){
                final /* synthetic */ TargetPanel this$1;
                {
                    this.this$1 = targetPanel;
                }

                public void actionPerformed(ActionEvent event) {
                    JFileChooser fileChooser = new JFileChooser(".");
                    fileChooser.setFileFilter(new MyFileFilter(new String[]{"class", "jar"}));
                    if (fileChooser.showOpenDialog(TargetPanel.access$2(this.this$1)) == 0) {
                        File file = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                        String fileName = file.getAbsolutePath();
                        TargetPanel.access$0(this.this$1).setText(fileName);
                        ProfileDialog.access$0(TargetPanel.access$2(this.this$1), fileName);
                        int index = fileName.lastIndexOf(46);
                        String mainPath = fileName.substring(index);
                        String extension = fileName.substring(index + 1, fileName.length());
                        if (extension.equals("jar")) {
                            Iterator<E> it = ProfileDialog.access$1(TargetPanel.access$2(this.this$1)).iterator();
                            boolean isInclude = false;
                            while (it.hasNext()) {
                                String vmOption = (String)it.next();
                                if (!vmOption.equals("-jar")) continue;
                                isInclude = true;
                            }
                            if (!isInclude) {
                                ProfileDialog.access$1(TargetPanel.access$2(this.this$1)).add("-jar");
                            }
                        } else {
                            Iterator<E> it = ProfileDialog.access$1(TargetPanel.access$2(this.this$1)).iterator();
                            boolean isInclude = false;
                            while (it.hasNext()) {
                                String vmOption = (String)it.next();
                                if (!vmOption.equals("-jar")) continue;
                                it.remove();
                            }
                        }
                        ProfileDialog.access$2(TargetPanel.access$2(this.this$1)).setText(TargetPanel.access$2(this.this$1).getCommand());
                        ProfileDialog.access$2(TargetPanel.access$2(this.this$1)).repaint();
                    }
                }
            });
            this.mainFileField.getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ TargetPanel this$1;
                {
                    this.this$1 = targetPanel;
                }

                public void changedUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                public void insertUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                private void changed(DocumentEvent event) {
                    String text = TargetPanel.access$0(this.this$1).getText();
                    File mainFile = new File(text);
                    if (mainFile.exists()) {
                        String absolutePath = mainFile.getAbsolutePath();
                        if (absolutePath.charAt(1) == ':') {
                            absolutePath = String.valueOf(Character.toUpperCase(absolutePath.charAt(0))) + absolutePath.substring(1);
                        }
                        ProfileDialog.access$0(TargetPanel.access$2(this.this$1), absolutePath);
                    } else {
                        ProfileDialog.access$0(TargetPanel.access$2(this.this$1), text);
                    }
                    ProfileDialog.access$2(TargetPanel.access$2(this.this$1)).setText(TargetPanel.access$2(this.this$1).getCommand());
                    ProfileDialog.access$2(TargetPanel.access$2(this.this$1)).repaint();
                }
            });
            this.argsField.getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ TargetPanel this$1;
                {
                    this.this$1 = targetPanel;
                }

                public void changedUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                public void insertUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                private void changed(DocumentEvent event) {
                    ProfileDialog.access$3(TargetPanel.access$2(this.this$1)).clear();
                    String text = TargetPanel.access$1(this.this$1).getText();
                    StringTokenizer st = new StringTokenizer(text, " \t");
                    while (st.hasMoreTokens()) {
                        String arg = st.nextToken();
                        arg = arg.trim();
                        ProfileDialog.access$3(TargetPanel.access$2(this.this$1)).add(String.valueOf(arg) + " ");
                    }
                    ProfileDialog.access$2(TargetPanel.access$2(this.this$1)).setText(TargetPanel.access$2(this.this$1).getCommand());
                    ProfileDialog.access$2(TargetPanel.access$2(this.this$1)).repaint();
                }
            });
        }

        static /* synthetic */ JTextField access$0(TargetPanel targetPanel) {
            return targetPanel.mainFileField;
        }

        static /* synthetic */ JTextField access$1(TargetPanel targetPanel) {
            return targetPanel.argsField;
        }

        static /* synthetic */ ProfileDialog access$2(TargetPanel targetPanel) {
            return targetPanel.ProfileDialog.this;
        }
    }

    private class ProfilerPanel
    extends JPanel {
        private final JTextField profilerField;
        private final JTextField logDirectoryField;

        ProfilerPanel() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            LineTextFieldPanel profilerPathPanel = new LineTextFieldPanel("");
            profilerPathPanel.setBorder(BorderFactory.createTitledBorder("Profiler path"));
            this.profilerField = profilerPathPanel.getTextField();
            File profiler = new File("profiler.dll");
            if (profiler.exists()) {
                this.profilerField.setText(profiler.getAbsolutePath());
            }
            JButton profilerButton = new JButton("...");
            profilerPathPanel.add(profilerButton);
            LineTextFieldPanel logDirectoryPanel = new LineTextFieldPanel(Profiler.DEFAULT_LOG_DIRECTORY);
            logDirectoryPanel.setBorder(BorderFactory.createTitledBorder("Log file Directory"));
            this.logDirectoryField = logDirectoryPanel.getTextField();
            JButton logDirectoryButton = new JButton("...");
            logDirectoryPanel.add(logDirectoryButton);
            cons.fill = 2;
            cons.anchor = 11;
            cons.gridx = 0;
            cons.weightx = 1.0;
            gb.setConstraints(profilerPathPanel, cons);
            this.add(profilerPathPanel);
            cons.weighty = 1.0;
            gb.setConstraints(logDirectoryPanel, cons);
            this.add(logDirectoryPanel);
            profilerButton.addActionListener(new ActionListener(this){
                final /* synthetic */ ProfilerPanel this$1;
                {
                    this.this$1 = profilerPanel;
                }

                public void actionPerformed(ActionEvent event) {
                    JFileChooser fileChooser = new JFileChooser(".");
                    fileChooser.setFileFilter(new MyFileFilter(new String[]{"dll"}));
                    if (fileChooser.showOpenDialog(ProfilerPanel.access$2(this.this$1)) == 0) {
                        File file = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                        String fileName = file.getName();
                        if (!fileName.equals("profiler.dll")) {
                            return;
                        }
                        fileName = file.getAbsolutePath();
                        ProfilerPanel.access$0(this.this$1).setText(fileName);
                        ProfilerPanel.access$0(this.this$1).repaint();
                    }
                }
            });
            logDirectoryButton.addActionListener(new ActionListener(this){
                final /* synthetic */ ProfilerPanel this$1;
                {
                    this.this$1 = profilerPanel;
                }

                public void actionPerformed(ActionEvent event) {
                    JFileChooser fileChooser = new JFileChooser(".");
                    fileChooser.setFileFilter(new MyFileFilter(new String[0]));
                    fileChooser.setFileSelectionMode(1);
                    if (fileChooser.showOpenDialog(ProfilerPanel.access$2(this.this$1)) == 0) {
                        File file = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                        String fileName = file.getAbsolutePath();
                        ProfilerPanel.access$1(this.this$1).setText(String.valueOf(fileName) + "\\");
                        ProfilerPanel.access$1(this.this$1).repaint();
                    }
                }
            });
        }

        public String getLogDirectory() {
            return this.logDirectoryField.getText();
        }

        public String getProfiler() {
            return this.profilerField.getText();
        }

        static /* synthetic */ JTextField access$0(ProfilerPanel profilerPanel) {
            return profilerPanel.profilerField;
        }

        static /* synthetic */ JTextField access$1(ProfilerPanel profilerPanel) {
            return profilerPanel.logDirectoryField;
        }

        static /* synthetic */ ProfileDialog access$2(ProfilerPanel profilerPanel) {
            return profilerPanel.ProfileDialog.this;
        }
    }

    private class VmOptionPanel
    extends JPanel {
        private final JTextField classpathField;
        private final JTextField optionField;

        VmOptionPanel() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            LineTextFieldPanel classpathPanel = new LineTextFieldPanel("");
            classpathPanel.setBorder(BorderFactory.createTitledBorder("classpath"));
            this.classpathField = classpathPanel.getTextField();
            String classPath = System.getProperty("java.class.path");
            StringBuffer buffer = new StringBuffer();
            StringTokenizer st = new StringTokenizer(classPath, ";");
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                File pathFile = new File(path);
                String absolutePath = pathFile.getAbsolutePath();
                if (absolutePath.charAt(absolutePath.length() - 1) != '\\') {
                    absolutePath = String.valueOf(absolutePath) + "\\";
                }
                buffer.append(absolutePath);
                ProfileDialog.this.classPathes.add(absolutePath);
                if (!st.hasMoreTokens()) continue;
                buffer.append(";");
            }
            this.classpathField.setText(buffer.toString());
            JButton classpathButton = new JButton("add...");
            classpathPanel.add(classpathButton);
            LineTextFieldPanel optionPanel = new LineTextFieldPanel("");
            optionPanel.setBorder(BorderFactory.createTitledBorder("vm options"));
            this.optionField = optionPanel.getTextField();
            cons.fill = 2;
            cons.anchor = 11;
            cons.gridx = 0;
            cons.weightx = 1.0;
            gb.setConstraints(classpathPanel, cons);
            this.add(classpathPanel);
            cons.weighty = 1.0;
            gb.setConstraints(optionPanel, cons);
            this.add(optionPanel);
            classpathButton.addActionListener(new ActionListener(this){
                final /* synthetic */ VmOptionPanel this$1;
                {
                    this.this$1 = vmOptionPanel;
                }

                public void actionPerformed(ActionEvent event) {
                    JFileChooser fileChooser = new JFileChooser(".");
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setFileFilter(new MyFileFilter(new String[]{"jar", "zip"}));
                    if (fileChooser.showOpenDialog(VmOptionPanel.access$2(this.this$1)) == 0) {
                        File file = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                        String absolutePath = file.getAbsolutePath();
                        if (absolutePath.lastIndexOf(".") == -1 && absolutePath.charAt(absolutePath.length() - 1) != '\\') {
                            absolutePath = String.valueOf(absolutePath) + "\\";
                        }
                        if (absolutePath.charAt(1) == ':') {
                            absolutePath = String.valueOf(Character.toUpperCase(absolutePath.charAt(0))) + absolutePath.substring(1);
                        }
                        if (!ProfileDialog.access$4(VmOptionPanel.access$2(this.this$1)).contains(absolutePath)) {
                            ProfileDialog.access$4(VmOptionPanel.access$2(this.this$1)).add(absolutePath);
                            VmOptionPanel.access$0(this.this$1).setText(String.valueOf(VmOptionPanel.access$0(this.this$1).getText()) + ";" + absolutePath);
                        }
                        ProfileDialog.access$2(VmOptionPanel.access$2(this.this$1)).setText(VmOptionPanel.access$2(this.this$1).getCommand());
                        ProfileDialog.access$2(VmOptionPanel.access$2(this.this$1)).repaint();
                    }
                }
            });
            this.classpathField.getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ VmOptionPanel this$1;
                {
                    this.this$1 = vmOptionPanel;
                }

                public void changedUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                public void insertUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                private void changed(DocumentEvent event) {
                    ProfileDialog.access$4(VmOptionPanel.access$2(this.this$1)).clear();
                    String text = VmOptionPanel.access$0(this.this$1).getText();
                    StringTokenizer st = new StringTokenizer(text, ";,");
                    while (st.hasMoreTokens()) {
                        String path = st.nextToken();
                        File pathFile = new File(path = path.trim());
                        if (!pathFile.exists()) continue;
                        String absolutePath = pathFile.getAbsolutePath();
                        int point = absolutePath.lastIndexOf(".");
                        if (point == -1 && absolutePath.charAt(absolutePath.length() - 1) != '\\') {
                            absolutePath = String.valueOf(absolutePath) + "\\";
                        }
                        if (absolutePath.charAt(1) == ':') {
                            absolutePath = String.valueOf(Character.toUpperCase(absolutePath.charAt(0))) + absolutePath.substring(1);
                        }
                        if (ProfileDialog.access$4(VmOptionPanel.access$2(this.this$1)).contains(absolutePath)) continue;
                        ProfileDialog.access$4(VmOptionPanel.access$2(this.this$1)).add(absolutePath);
                    }
                    ProfileDialog.access$2(VmOptionPanel.access$2(this.this$1)).setText(VmOptionPanel.access$2(this.this$1).getCommand());
                    ProfileDialog.access$2(VmOptionPanel.access$2(this.this$1)).repaint();
                }
            });
            this.optionField.getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ VmOptionPanel this$1;
                {
                    this.this$1 = vmOptionPanel;
                }

                public void changedUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                public void insertUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                private void changed(DocumentEvent event) {
                    ProfileDialog.access$5(VmOptionPanel.access$2(this.this$1), VmOptionPanel.access$1(this.this$1).getText());
                    ProfileDialog.access$2(VmOptionPanel.access$2(this.this$1)).setText(VmOptionPanel.access$2(this.this$1).getCommand());
                    ProfileDialog.access$2(VmOptionPanel.access$2(this.this$1)).repaint();
                }
            });
        }

        static /* synthetic */ JTextField access$0(VmOptionPanel vmOptionPanel) {
            return vmOptionPanel.classpathField;
        }

        static /* synthetic */ JTextField access$1(VmOptionPanel vmOptionPanel) {
            return vmOptionPanel.optionField;
        }

        static /* synthetic */ ProfileDialog access$2(VmOptionPanel vmOptionPanel) {
            return vmOptionPanel.ProfileDialog.this;
        }
    }

    private class FilterPanel
    extends JPanel {
        private final FilteredMethodPanel filteredMethodPanel;
        private final StartMethodPanel startMethodPanel;

        FilterPanel() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            this.startMethodPanel = new StartMethodPanel();
            this.startMethodPanel.setBorder(BorderFactory.createTitledBorder("Loging start method."));
            this.filteredMethodPanel = new FilteredMethodPanel();
            this.filteredMethodPanel.setBorder(BorderFactory.createTitledBorder("Filter method"));
            cons.fill = 2;
            cons.anchor = 18;
            cons.weightx = 1.0;
            cons.weighty = 0.0;
            gb.setConstraints(this.startMethodPanel, cons);
            this.add(this.startMethodPanel);
            cons.fill = 1;
            cons.weighty = 1.0;
            cons.gridx = 0;
            gb.setConstraints(this.filteredMethodPanel, cons);
            this.add(this.filteredMethodPanel);
        }

        public boolean recordFilteredMethods() {
            return this.filteredMethodPanel.isFilter();
        }

        public List getFilteredMethods() {
            return this.filteredMethodPanel.getFilteredMethods();
        }

        public Method getStartMethod() {
            return this.startMethodPanel.getStartMethod();
        }
    }

    private interface MethodEntryListener {
        public void entry(Method var1);
    }

    private class StartMethodPanel
    extends JPanel
    implements MethodEntryListener {
        private final JTable startMethodTable;
        private final JCheckBox startMethodCheck;
        private final JButton setButton;
        private final MethodEntryDialog methodEntry;

        StartMethodPanel() {
            this.methodEntry = new MethodEntryDialog(this);
            this.startMethodCheck = new JCheckBox("Set loging start method.");
            MethodTableModel model = new MethodTableModel();
            model.addMethod(new Method("*", "*", "*"));
            this.startMethodTable = new JTable(model);
            JScrollPane tableScroll = new JScrollPane(this.startMethodTable);
            tableScroll.setVerticalScrollBarPolicy(21);
            tableScroll.setHorizontalScrollBarPolicy(31);
            this.startMethodTable.setRowSelectionAllowed(false);
            this.startMethodTable.setCellSelectionEnabled(false);
            this.setButton = new JButton("Set");
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.anchor = 18;
            cons.gridx = 0;
            cons.gridwidth = 3;
            cons.weightx = 1.0;
            gb.setConstraints(this.startMethodCheck, cons);
            this.add(this.startMethodCheck);
            cons.fill = 1;
            cons.weighty = 1.0;
            gb.setConstraints(tableScroll, cons);
            this.add(tableScroll);
            cons.fill = 0;
            cons.weightx = 0.0;
            cons.gridwidth = 1;
            cons.gridx = 3;
            cons.gridy = 1;
            gb.setConstraints(this.setButton, cons);
            this.add(this.setButton);
            tableScroll.setMaximumSize(new Dimension(100, 33));
            tableScroll.setMinimumSize(new Dimension(100, 33));
            this.startMethodTable.setBackground(Color.LIGHT_GRAY);
            this.setButton.setEnabled(false);
            this.setButton.addActionListener(new ActionListener(this){
                final /* synthetic */ StartMethodPanel this$1;
                {
                    this.this$1 = startMethodPanel;
                }

                public void actionPerformed(ActionEvent arg0) {
                    StartMethodPanel.access$0(this.this$1).setVisible(true);
                }
            });
            this.startMethodCheck.addActionListener(new ActionListener(this){
                final /* synthetic */ StartMethodPanel this$1;
                {
                    this.this$1 = startMethodPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    boolean selected = StartMethodPanel.access$1(this.this$1).isSelected();
                    StartMethodPanel.access$2(this.this$1).setEnabled(selected);
                    if (selected) {
                        StartMethodPanel.access$3(this.this$1).setBackground(Color.WHITE);
                    } else {
                        StartMethodPanel.access$3(this.this$1).setBackground(Color.LIGHT_GRAY);
                    }
                }
            });
        }

        public void entry(Method method) {
            MethodTableModel model = (MethodTableModel)this.startMethodTable.getModel();
            if (model.size() == 0) {
                model.add(method);
            } else if (model.size() == 1) {
                model.delete(0);
                model.add(method);
            }
        }

        public Method getStartMethod() {
            if (!this.startMethodCheck.isSelected()) {
                return null;
            }
            MethodTableModel model = (MethodTableModel)this.startMethodTable.getModel();
            if (model.size() != 1) {
                return null;
            }
            Method method = (Method)((MethodTableModel)this.startMethodTable.getModel()).getMethods().get(0);
            if (method.getPackageName().equals("") && method.getClassName().equals("") && method.getMethodName().equals("")) {
                return null;
            }
            return method;
        }

        static /* synthetic */ MethodEntryDialog access$0(StartMethodPanel startMethodPanel) {
            return startMethodPanel.methodEntry;
        }

        static /* synthetic */ JCheckBox access$1(StartMethodPanel startMethodPanel) {
            return startMethodPanel.startMethodCheck;
        }

        static /* synthetic */ JButton access$2(StartMethodPanel startMethodPanel) {
            return startMethodPanel.setButton;
        }

        static /* synthetic */ JTable access$3(StartMethodPanel startMethodPanel) {
            return startMethodPanel.startMethodTable;
        }
    }

    private class FilteredMethodPanel
    extends JPanel
    implements MethodEntryListener {
        private final int ADD_MODE = 0;
        private final int EDIT_MODE = 1;
        private final JCheckBox libraryCheck;
        private final JCheckBox filterCheck;
        private final JTable filteredMethodTable;
        private final JButton addButton;
        private final JButton deleteButton;
        private final JButton editButton;
        private final MethodEntryDialog methodEntry;
        private int entryMode;

        FilteredMethodPanel() {
            this.methodEntry = new MethodEntryDialog(this);
            this.entryMode = 0;
            ArrayList<Method> defaultFilteredMethods = new ArrayList<Method>();
            defaultFilteredMethods.add(new Method("java*", "*", "*"));
            defaultFilteredMethods.add(new Method("javax*", "*", "*"));
            defaultFilteredMethods.add(new Method("sun*", "*", "*"));
            defaultFilteredMethods.add(new Method("org*", "*", "*"));
            defaultFilteredMethods.add(new Method("com*", "*", "*"));
            this.filteredMethodTable = new JTable(new MethodTableModel(defaultFilteredMethods));
            JScrollPane tableScroll = new JScrollPane(this.filteredMethodTable);
            this.addButton = new JButton("Add");
            this.deleteButton = new JButton("Del");
            this.editButton = new JButton("Edit");
            this.filterCheck = new JCheckBox("Filter method calls.", true);
            this.libraryCheck = new JCheckBox("Record only called by a non filtered method.", false);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 0;
            cons.anchor = 18;
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 1.0;
            gb.setConstraints(this.filterCheck, cons);
            this.add(this.filterCheck);
            cons.gridy = 1;
            gb.setConstraints(this.libraryCheck, cons);
            this.add(this.libraryCheck);
            cons.fill = 1;
            cons.gridy = 2;
            cons.gridwidth = 3;
            cons.gridheight = 3;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            gb.setConstraints(tableScroll, cons);
            this.add(tableScroll);
            cons.fill = 0;
            cons.gridx = 3;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            gb.setConstraints(this.addButton, cons);
            this.add(this.addButton);
            cons.gridy = 3;
            gb.setConstraints(this.editButton, cons);
            this.add(this.editButton);
            cons.gridy = 4;
            gb.setConstraints(this.deleteButton, cons);
            this.add(this.deleteButton);
            this.addButton.addActionListener(new ActionListener(this){
                final /* synthetic */ FilteredMethodPanel this$1;
                {
                    this.this$1 = filteredMethodPanel;
                }

                public void actionPerformed(ActionEvent arg0) {
                    FilteredMethodPanel.access$0(this.this$1, 0);
                    FilteredMethodPanel.access$1(this.this$1).clear();
                    FilteredMethodPanel.access$1(this.this$1).setVisible(true);
                }
            });
            this.editButton.addActionListener(new ActionListener(this){
                final /* synthetic */ FilteredMethodPanel this$1;
                {
                    this.this$1 = filteredMethodPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    FilteredMethodPanel.access$0(this.this$1, 1);
                    int index = FilteredMethodPanel.access$2(this.this$1).getSelectedRow();
                    FilteredMethodPanel.access$1(this.this$1).setMethod(((MethodTableModel)FilteredMethodPanel.access$2(this.this$1).getModel()).getMethod(index));
                    FilteredMethodPanel.access$1(this.this$1).setVisible(true);
                }
            });
            this.deleteButton.addActionListener(new ActionListener(this){
                final /* synthetic */ FilteredMethodPanel this$1;
                {
                    this.this$1 = filteredMethodPanel;
                }

                public void actionPerformed(ActionEvent arg0) {
                    int index = FilteredMethodPanel.access$2(this.this$1).getSelectedRow();
                    ((MethodTableModel)FilteredMethodPanel.access$2(this.this$1).getModel()).delete(index);
                }
            });
            this.filterCheck.addActionListener(new ActionListener(this){
                final /* synthetic */ FilteredMethodPanel this$1;
                {
                    this.this$1 = filteredMethodPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    boolean selected = FilteredMethodPanel.access$3(this.this$1).isSelected();
                    FilteredMethodPanel.access$4(this.this$1).setEnabled(selected);
                    FilteredMethodPanel.access$5(this.this$1).setEnabled(selected);
                    FilteredMethodPanel.access$6(this.this$1).setEnabled(selected);
                    FilteredMethodPanel.access$7(this.this$1).setEnabled(selected);
                    FilteredMethodPanel.access$2(this.this$1).setEnabled(selected);
                    if (selected) {
                        FilteredMethodPanel.access$2(this.this$1).setBackground(Color.WHITE);
                    } else {
                        FilteredMethodPanel.access$2(this.this$1).getSelectionModel().clearSelection();
                        FilteredMethodPanel.access$2(this.this$1).setBackground(Color.LIGHT_GRAY);
                    }
                }
            });
        }

        public boolean isFilter() {
            return this.libraryCheck.isSelected();
        }

        public List getFilteredMethods() {
            return ((MethodTableModel)this.filteredMethodTable.getModel()).getMethods();
        }

        public void entry(Method method) {
            if (this.entryMode == 0) {
                ((MethodTableModel)this.filteredMethodTable.getModel()).add(method);
            } else if (this.entryMode == 1) {
                ((MethodTableModel)this.filteredMethodTable.getModel()).set(this.filteredMethodTable.getSelectedRow(), method);
            }
        }

        static /* synthetic */ void access$0(FilteredMethodPanel filteredMethodPanel, int n) {
            filteredMethodPanel.entryMode = n;
        }

        static /* synthetic */ MethodEntryDialog access$1(FilteredMethodPanel filteredMethodPanel) {
            return filteredMethodPanel.methodEntry;
        }

        static /* synthetic */ JTable access$2(FilteredMethodPanel filteredMethodPanel) {
            return filteredMethodPanel.filteredMethodTable;
        }

        static /* synthetic */ JCheckBox access$3(FilteredMethodPanel filteredMethodPanel) {
            return filteredMethodPanel.filterCheck;
        }

        static /* synthetic */ JCheckBox access$4(FilteredMethodPanel filteredMethodPanel) {
            return filteredMethodPanel.libraryCheck;
        }

        static /* synthetic */ JButton access$5(FilteredMethodPanel filteredMethodPanel) {
            return filteredMethodPanel.addButton;
        }

        static /* synthetic */ JButton access$6(FilteredMethodPanel filteredMethodPanel) {
            return filteredMethodPanel.deleteButton;
        }

        static /* synthetic */ JButton access$7(FilteredMethodPanel filteredMethodPanel) {
            return filteredMethodPanel.editButton;
        }
    }

    private class MethodEntryDialog
    extends JDialog {
        private final CheckTextFieldPanel packageCheck;
        private final CheckTextFieldPanel classCheck;
        private final CheckTextFieldPanel methodCheck;
        private final MethodEntryListener listener;

        MethodEntryDialog(MethodEntryListener listener) {
            super(ProfileDialog.this, "Set Target Method", true);
            this.packageCheck = new CheckTextFieldPanel("Specify target package", "*");
            this.classCheck = new CheckTextFieldPanel("Specify target class", "*");
            this.methodCheck = new CheckTextFieldPanel("Specify target emthod", "*");
            this.listener = listener;
            this.packageCheck.setBorder(BorderFactory.createTitledBorder("Package"));
            this.classCheck.setBorder(BorderFactory.createTitledBorder("Class"));
            this.methodCheck.setBorder(BorderFactory.createTitledBorder("Method"));
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 2;
            cons.anchor = 18;
            cons.gridx = 0;
            cons.gridwidth = 2;
            cons.weightx = 1.0;
            gb.setConstraints(this.packageCheck, cons);
            this.add(this.packageCheck);
            gb.setConstraints(this.classCheck, cons);
            this.add(this.classCheck);
            gb.setConstraints(this.methodCheck, cons);
            this.add(this.methodCheck);
            cons.weighty = 1.0;
            cons.gridwidth = 1;
            cons.fill = 0;
            cons.anchor = 10;
            gb.setConstraints(okButton, cons);
            this.add(okButton);
            cons.gridx = 1;
            gb.setConstraints(cancelButton, cons);
            this.add(cancelButton);
            this.pack();
            okButton.addActionListener(new ActionListener(this){
                final /* synthetic */ MethodEntryDialog this$1;
                {
                    this.this$1 = methodEntryDialog;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.this$1.setVisible(false);
                    MethodEntryDialog.access$0(this.this$1).entry(new Method(MethodEntryDialog.access$1(this.this$1).getText().trim(), MethodEntryDialog.access$2(this.this$1).getText().trim(), MethodEntryDialog.access$3(this.this$1).getText().trim()));
                }
            });
            cancelButton.addActionListener(new ActionListener(this){
                final /* synthetic */ MethodEntryDialog this$1;
                {
                    this.this$1 = methodEntryDialog;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.this$1.setVisible(false);
                }
            });
        }

        public void setVisible(boolean b) {
            if (b) {
                this.setLocationRelativeTo(ProfileDialog.this.owner);
            }
            super.setVisible(b);
        }

        public void clear() {
            this.getPackageCheck().clear();
            this.getClassCheck().clear();
            this.getMethodCheck().clear();
        }

        public void setMethod(Method method) {
            this.clear();
            if (!method.getPackageName().equals("*")) {
                this.getPackageCheck().check();
                this.getPackageCheck().selected();
            }
            if (!method.getClassName().equals("*")) {
                this.getClassCheck().check();
                this.getClassCheck().selected();
            }
            if (!method.getMethodName().equals("*")) {
                this.getMethodCheck().check();
                this.getMethodCheck().selected();
            }
            this.getPackageCheck().setText(method.getPackageName());
            this.getClassCheck().setText(method.getClassName());
            this.getMethodCheck().setText(method.getMethodName());
        }

        public CheckTextFieldPanel getClassCheck() {
            return this.classCheck;
        }

        public CheckTextFieldPanel getMethodCheck() {
            return this.methodCheck;
        }

        public CheckTextFieldPanel getPackageCheck() {
            return this.packageCheck;
        }

        static /* synthetic */ MethodEntryListener access$0(MethodEntryDialog methodEntryDialog) {
            return methodEntryDialog.listener;
        }

        static /* synthetic */ CheckTextFieldPanel access$1(MethodEntryDialog methodEntryDialog) {
            return methodEntryDialog.packageCheck;
        }

        static /* synthetic */ CheckTextFieldPanel access$2(MethodEntryDialog methodEntryDialog) {
            return methodEntryDialog.classCheck;
        }

        static /* synthetic */ CheckTextFieldPanel access$3(MethodEntryDialog methodEntryDialog) {
            return methodEntryDialog.methodCheck;
        }
    }
}

