/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencefilter;

import amida.library.StringPatternComparator;
import amida.node.CallNode;
import amida.sequencefilter.ObjectFilter;
import amida.sequencer.ObjectGroupe;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjectUnifyFilter
extends ObjectFilter {
    public ObjectUnifyFilter(String packageName, String className, Set ids, boolean otherId) {
        super(packageName, className, ids, otherId);
    }

    public void makeSuitableGroupe(CallNode node, Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            ObjectGroupe groupe = (ObjectGroupe)it.next().getValue();
            if (!this.isSuitableGroupe(groupe)) continue;
            map.put(node, groupe);
            groupe.addIds(node.getId());
            groupe.getSequenceObject().setPackageName(this.getPackageName());
            groupe.getSequenceObject().setClassName(this.getClassName());
            groupe.getSequenceObject().setRenewable(false);
            return;
        }
        map.put(node, new ObjectGroupe(node));
    }

    private boolean isSuitableGroupe(ObjectGroupe groupe) {
        String groupePackage = groupe.getSequenceObject().getPackageName();
        String groupeClass = groupe.getSequenceObject().getClassName();
        Set groupeId = groupe.getSequenceObject().getIds();
        if (this.getPackageName() != null && !StringPatternComparator.compareStringPattern(this.getPackageName(), groupePackage)) {
            return false;
        }
        if (this.getClassName() != null && !StringPatternComparator.compareStringPattern(this.getClassName(), groupeClass)) {
            return false;
        }
        return this.getIds() == null || this.getIds().isEmpty() || this.getIds().containsAll(groupeId);
    }
}

