/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencefilter.gui;

import amida.library.CheckTextFieldPanel;
import amida.sequencefilter.IMethodFilter;
import amida.sequencefilter.IPreObjectFilter;
import amida.sequencefilter.gui.MethodFilter;
import amida.sequencefilter.gui.MethodFilterTableModel;
import amida.sequencefilter.gui.ObjectFilter;
import amida.sequencefilter.gui.ObjectFilterTableModel;
import amida.sequencefilter.gui.SequenceFilter;
import amida.sequencer.SequenceModel;
import amida.sequencer.gui.MainFrame;
import amida.sequencer.gui.SequenceDiagramPanel;
import amida.sequencer.gui.SequenceDiagramTabbedPane;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class FilterDialog
extends JDialog {
    public static final int OBJECT_FILTER = 0;
    public static final int METHOD_FILTER = 1;
    private static final FilterDialog singleton = new FilterDialog();
    private final MethodFilterPanel methodFilter = new MethodFilterPanel();
    private final ObjectFilterPanel objectFilter = new ObjectFilterPanel();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final JButton okButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final JFrame owner = MainFrame.getInstance();

    private FilterDialog() {
        super(MainFrame.getInstance(), "Filters", true);
        this.tabbedPane.add("ObjectFilter", this.objectFilter);
        this.tabbedPane.add("MethofFilter", this.methodFilter);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        Container cp = this.getContentPane();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        cp.setLayout(gb);
        cons.fill = 1;
        cons.gridx = 0;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        gb.setConstraints(this.tabbedPane, cons);
        cp.add(this.tabbedPane);
        cons.weighty = 0.0;
        gb.setConstraints(buttonPanel, cons);
        cp.add(buttonPanel);
        this.tabbedPane.setPreferredSize(new Dimension(800, 300));
        this.setDefaultCloseOperation(1);
        this.pack();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.setVisible(false);
                FilterDialog.this.apply();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.setVisible(false);
            }
        });
    }

    public static FilterDialog getInstance() {
        return singleton;
    }

    public void apply() {
        SequenceModel model;
        SequenceDiagramPanel diagram;
        SequenceFilter filter;
        SequenceModel model2;
        int i = 0;
        while (i < SequenceDiagramTabbedPane.getInstance().getTabCount()) {
            model2 = SequenceDiagramTabbedPane.getInstance().getDiagram(i).getModel();
            model2.clearAllFilters();
            ++i;
        }
        i = 0;
        while (i < this.objectFilter.getFilterNum()) {
            filter = this.objectFilter.getFilter(i);
            diagram = SequenceDiagramTabbedPane.getInstance().getDiagram(filter.getDiagramName());
            if (diagram != null) {
                model = diagram.getModel();
                model.addPreObjectFilter((IPreObjectFilter)filter.getFilter());
            }
            ++i;
        }
        i = 0;
        while (i < this.methodFilter.getFilterNum()) {
            filter = this.methodFilter.getFilter(i);
            diagram = SequenceDiagramTabbedPane.getInstance().getDiagram(filter.getDiagramName());
            if (diagram != null) {
                model = diagram.getModel();
                model.addPreMethodFilter((IMethodFilter)filter.getFilter());
            }
            ++i;
        }
        i = 0;
        while (i < SequenceDiagramTabbedPane.getInstance().getTabCount()) {
            model2 = SequenceDiagramTabbedPane.getInstance().getDiagram(i).getModel();
            model2.renew();
            ++i;
        }
    }

    public void setSelectedTab(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public void setVisibleOfSetDialog(int index, boolean b) {
        if (index == 0) {
            this.objectFilter.getObjectFilterSetDialog().setVisible(b);
        }
    }

    public void setObjectFilterToSetDailog(ObjectFilter filter) {
        this.objectFilter.getObjectFilterSetDialog().clear();
        this.objectFilter.setEntryMode(0);
        this.objectFilter.getObjectFilterSetDialog().setFilterData(filter);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.owner);
        }
        super.setVisible(b);
    }

    private abstract class FilterPanel
    extends JPanel {
        protected static final int ADD_MODE = 0;
        protected static final int EDIT_MODE = 1;
        private final JTable filterTable = new JTable();
        private final JButton addButton = new JButton("add");
        private final JButton deleteButton = new JButton("delete");
        private final JButton editButton = new JButton("edit");
        private int entryMode;

        protected FilterPanel() {
            JScrollPane tableScroll = new JScrollPane(this.filterTable);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(3));
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.editButton);
            buttonPanel.add(this.deleteButton);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 1;
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.gridwidth = 3;
            cons.gridheight = 3;
            gb.setConstraints(tableScroll, cons);
            this.add(tableScroll);
            cons.fill = 2;
            cons.anchor = 18;
            cons.gridx = 3;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            gb.setConstraints(this.addButton, cons);
            this.add(this.addButton);
            cons.gridy = 1;
            gb.setConstraints(this.editButton, cons);
            this.add(this.editButton);
            cons.gridy = 2;
            cons.weighty = 1.0;
            gb.setConstraints(this.deleteButton, cons);
            this.add(this.deleteButton);
        }

        protected void setModel(TableModel model) {
            this.filterTable.setModel(model);
        }

        protected void addAddButtonActionListener(ActionListener listener) {
            this.addButton.addActionListener(listener);
        }

        protected void addDeleteButtonActionListener(ActionListener listener) {
            this.deleteButton.addActionListener(listener);
        }

        protected void addEditbuttonActionListener(ActionListener listener) {
            this.editButton.addActionListener(listener);
        }

        protected int getSelectedIndex() {
            return this.filterTable.getSelectedRow();
        }

        protected int getEntryMode() {
            return this.entryMode;
        }

        protected void setEntryMode(int mode) {
            this.entryMode = mode;
        }

        protected abstract int getFilterNum();

        protected abstract SequenceFilter getFilter(int var1);
    }

    private class MethodFilterPanel
    extends FilterPanel
    implements SetMethodListener {
        private MethodFilterTableModel model = new MethodFilterTableModel();
        private MethodFilterSetDialog methodDialog;

        MethodFilterPanel() {
            this.methodDialog = new MethodFilterSetDialog(this);
            super.setModel(this.model);
            this.addAddButtonActionListener(new ActionListener(this){
                final /* synthetic */ MethodFilterPanel this$1;
                {
                    this.this$1 = methodFilterPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setEntryMode(0);
                    MethodFilterPanel.access$0(this.this$1).setVisible(true);
                }
            });
            this.addDeleteButtonActionListener(new ActionListener(this){
                final /* synthetic */ MethodFilterPanel this$1;
                {
                    this.this$1 = methodFilterPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    MethodFilterPanel.access$1(this.this$1).removeMethodFilter(this.this$1.getSelectedIndex());
                }
            });
            this.addEditbuttonActionListener(new ActionListener(this){
                final /* synthetic */ MethodFilterPanel this$1;
                {
                    this.this$1 = methodFilterPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setEntryMode(1);
                    SequenceFilter filter = MethodFilterPanel.access$1(this.this$1).getFilter(this.this$1.getSelectedIndex());
                    if (filter != null) {
                        MethodFilterPanel.access$0(this.this$1).setFilterData(filter);
                        MethodFilterPanel.access$0(this.this$1).setVisible(true);
                    }
                }
            });
        }

        protected int getFilterNum() {
            return this.model.getRowCount();
        }

        protected SequenceFilter getFilter(int index) {
            return this.model.getFilter(index);
        }

        public void entry(MethodFilter filter) {
            if (this.getEntryMode() == 0) {
                this.model.addMethodFilter(filter);
            } else if (this.getEntryMode() == 1) {
                this.model.setMethodFilter(this.getSelectedIndex(), filter);
            }
        }

        protected MethodFilterSetDialog getMethodFilterSetDialog() {
            return this.methodDialog;
        }

        static /* synthetic */ MethodFilterSetDialog access$0(MethodFilterPanel methodFilterPanel) {
            return methodFilterPanel.methodDialog;
        }

        static /* synthetic */ MethodFilterTableModel access$1(MethodFilterPanel methodFilterPanel) {
            return methodFilterPanel.model;
        }
    }

    private class ObjectFilterPanel
    extends FilterPanel
    implements SetObjectListener {
        private ObjectFilterTableModel model = new ObjectFilterTableModel();
        private ObjectFilterSetDialog objectDialog;

        ObjectFilterPanel() {
            this.objectDialog = new ObjectFilterSetDialog(this);
            super.setModel(this.model);
            this.addAddButtonActionListener(new ActionListener(this){
                final /* synthetic */ ObjectFilterPanel this$1;
                {
                    this.this$1 = objectFilterPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setEntryMode(0);
                    ObjectFilterPanel.access$0(this.this$1).setVisible(true);
                }
            });
            this.addDeleteButtonActionListener(new ActionListener(this){
                final /* synthetic */ ObjectFilterPanel this$1;
                {
                    this.this$1 = objectFilterPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    ObjectFilterPanel.access$1(this.this$1).removeObjectFilter(this.this$1.getSelectedIndex());
                }
            });
            this.addEditbuttonActionListener(new ActionListener(this){
                final /* synthetic */ ObjectFilterPanel this$1;
                {
                    this.this$1 = objectFilterPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setEntryMode(1);
                    SequenceFilter filter = ObjectFilterPanel.access$1(this.this$1).getFilter(this.this$1.getSelectedIndex());
                    if (filter != null) {
                        ObjectFilterPanel.access$0(this.this$1).setFilterData(filter);
                        ObjectFilterPanel.access$0(this.this$1).setVisible(true);
                    }
                }
            });
        }

        public void entry(ObjectFilter object) {
            if (this.getEntryMode() == 0) {
                this.model.addObjectFilter(object);
            } else if (this.getEntryMode() == 1) {
                this.model.setObjectFilter(this.getSelectedIndex(), object);
            }
        }

        protected int getFilterNum() {
            return this.model.getRowCount();
        }

        protected SequenceFilter getFilter(int index) {
            return this.model.getFilter(index);
        }

        protected ObjectFilterSetDialog getObjectFilterSetDialog() {
            return this.objectDialog;
        }

        static /* synthetic */ ObjectFilterSetDialog access$0(ObjectFilterPanel objectFilterPanel) {
            return objectFilterPanel.objectDialog;
        }

        static /* synthetic */ ObjectFilterTableModel access$1(ObjectFilterPanel objectFilterPanel) {
            return objectFilterPanel.model;
        }
    }

    private interface SetObjectListener {
        public void entry(ObjectFilter var1);
    }

    private class ObjectFilterSetDialog
    extends JDialog {
        private final SetObjectListener listener;
        private final SetObjectPanel objectPanel;
        private final TabListPanel listPanel;
        private final JRadioButton deleteButton;
        private final JRadioButton unifyButton;

        ObjectFilterSetDialog(SetObjectListener listener) {
            super(FilterDialog.this, "Set Object Filter", true);
            this.objectPanel = new SetObjectPanel();
            this.listPanel = new TabListPanel();
            this.deleteButton = new JRadioButton("delete", true);
            this.unifyButton = new JRadioButton("unify");
            this.listener = listener;
            ButtonGroup group = new ButtonGroup();
            group.add(this.deleteButton);
            group.add(this.unifyButton);
            this.listPanel.setBorder(BorderFactory.createTitledBorder("Target Diagram"));
            this.objectPanel.setBorder(BorderFactory.createTitledBorder("Target Object"));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(0));
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            JPanel radioButtonPanel = new JPanel();
            radioButtonPanel.setLayout(new FlowLayout(0));
            radioButtonPanel.add(this.deleteButton);
            radioButtonPanel.add(this.unifyButton);
            radioButtonPanel.setBorder(BorderFactory.createTitledBorder("Filter Kind"));
            Container cp = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            cp.setLayout(gb);
            cons.fill = 1;
            cons.weightx = 0.5;
            cons.weighty = 1.0;
            cons.gridwidth = 1;
            cons.gridheight = 4;
            cons.gridy = 0;
            cons.gridx = 0;
            gb.setConstraints(this.listPanel, cons);
            cp.add(this.listPanel);
            cons.weighty = 0.0;
            cons.gridheight = 1;
            cons.gridx = 1;
            gb.setConstraints(radioButtonPanel, cons);
            cp.add(radioButtonPanel);
            cons.gridheight = 3;
            cons.gridy = 1;
            gb.setConstraints(this.objectPanel, cons);
            cp.add(this.objectPanel);
            cons.fill = 0;
            cons.anchor = 18;
            cons.weighty = 0.0;
            cons.gridy = 4;
            cons.gridx = 0;
            gb.setConstraints(buttonPanel, cons);
            this.add(buttonPanel);
            this.listPanel.setPreferredSize(new Dimension(200, 250));
            this.objectPanel.setPreferredSize(new Dimension(200, 250));
            this.setDefaultCloseOperation(1);
            this.pack();
            okButton.addActionListener(new ActionListener(this){
                final /* synthetic */ ObjectFilterSetDialog this$1;
                {
                    this.this$1 = objectFilterSetDialog;
                }

                public void actionPerformed(ActionEvent arg0) {
                    if (ObjectFilterSetDialog.access$0(this.this$1).getSelectedIndex() == -1) {
                        JOptionPane.showMessageDialog(this.this$1, "Please select any diagram.", "Filter Error", 0);
                        return;
                    }
                    this.this$1.setVisible(false);
                    int type = -1;
                    if (ObjectFilterSetDialog.access$1(this.this$1).isSelected()) {
                        type = 0;
                    } else if (ObjectFilterSetDialog.access$2(this.this$1).isSelected()) {
                        type = 1;
                    }
                    this.this$1.getListener().entry(new ObjectFilter(ObjectFilterSetDialog.access$0(this.this$1).getSelectedString(), type, ObjectFilterSetDialog.access$3(this.this$1).getPackageName(), ObjectFilterSetDialog.access$3(this.this$1).getClassName(), ObjectFilterSetDialog.access$3(this.this$1).getIdString()));
                    this.this$1.clear();
                }
            });
            cancelButton.addActionListener(new ActionListener(this){
                final /* synthetic */ ObjectFilterSetDialog this$1;
                {
                    this.this$1 = objectFilterSetDialog;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.this$1.setVisible(false);
                    this.this$1.clear();
                }
            });
        }

        public void clear() {
            this.objectPanel.clear();
            this.deleteButton.setSelected(true);
        }

        public void setFilterData(SequenceFilter filter) {
            ObjectFilter objectFilter = (ObjectFilter)filter;
            this.listPanel.setSelectedObject(filter.getDiagramName());
            if (objectFilter.getTypeName().equals("Delete")) {
                this.deleteButton.setSelected(true);
            } else if (objectFilter.getTypeName().equals("Unify")) {
                this.unifyButton.setSelected(true);
            }
            this.objectPanel.setPackageName(objectFilter.getPackageName());
            this.objectPanel.setClassName(objectFilter.getClassName());
            this.objectPanel.setIds(objectFilter.getIds());
        }

        public void setVisible(boolean b) {
            if (b) {
                this.setLocationRelativeTo(FilterDialog.this);
            }
            super.setVisible(b);
        }

        public SetObjectListener getListener() {
            return this.listener;
        }

        static /* synthetic */ TabListPanel access$0(ObjectFilterSetDialog objectFilterSetDialog) {
            return objectFilterSetDialog.listPanel;
        }

        static /* synthetic */ JRadioButton access$1(ObjectFilterSetDialog objectFilterSetDialog) {
            return objectFilterSetDialog.deleteButton;
        }

        static /* synthetic */ JRadioButton access$2(ObjectFilterSetDialog objectFilterSetDialog) {
            return objectFilterSetDialog.unifyButton;
        }

        static /* synthetic */ SetObjectPanel access$3(ObjectFilterSetDialog objectFilterSetDialog) {
            return objectFilterSetDialog.objectPanel;
        }
    }

    private interface SetMethodListener {
        public void entry(MethodFilter var1);
    }

    private class MethodFilterSetDialog
    extends JDialog {
        private SetMethodListener listener;
        private final TabListPanel listPanel;
        private final CheckTextFieldPanel methodField;
        private final CallerCalleePanel objectsPanel;
        private final JRadioButton deleteAllButton;
        private final JRadioButton deleteOnlyButton;

        MethodFilterSetDialog(SetMethodListener listener) {
            super(FilterDialog.this, "Set Method Filter", true);
            this.listPanel = new TabListPanel();
            this.methodField = new CheckTextFieldPanel("Specify method name.", "*");
            this.objectsPanel = new CallerCalleePanel();
            this.deleteAllButton = new JRadioButton("Delete all sequence from this method.", true);
            this.deleteOnlyButton = new JRadioButton("Delete this method only.");
            this.listener = listener;
            this.listPanel.setBorder(BorderFactory.createTitledBorder("Target Diagram"));
            this.objectsPanel.setBorder(BorderFactory.createTitledBorder("Objects"));
            JPanel methodPanel = new JPanel();
            methodPanel.setBorder(BorderFactory.createTitledBorder("Method Name"));
            GridBagLayout gb1 = new GridBagLayout();
            methodPanel.setLayout(gb1);
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.fill = 2;
            cons1.anchor = 18;
            cons1.weightx = 1.0;
            gb1.setConstraints(this.methodField, cons1);
            methodPanel.add(this.methodField);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(0));
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            JPanel filterOptionPanel = new JPanel();
            filterOptionPanel.setLayout(new FlowLayout(0));
            filterOptionPanel.add(this.deleteAllButton);
            filterOptionPanel.add(this.deleteOnlyButton);
            ButtonGroup group = new ButtonGroup();
            group.add(this.deleteAllButton);
            group.add(this.deleteOnlyButton);
            filterOptionPanel.setBorder(BorderFactory.createTitledBorder("Filter Kind"));
            Container cp = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            cp.setLayout(gb);
            cons.fill = 1;
            cons.weightx = 0.5;
            cons.weighty = 1.0;
            cons.gridwidth = 1;
            cons.gridheight = 5;
            cons.gridy = 0;
            cons.gridx = 0;
            gb.setConstraints(this.listPanel, cons);
            cp.add(this.listPanel);
            cons.weighty = 0.0;
            cons.gridheight = 1;
            cons.gridwidth = 2;
            cons.gridx = 1;
            gb.setConstraints(filterOptionPanel, cons);
            cp.add(filterOptionPanel);
            cons.gridy = 1;
            gb.setConstraints(methodPanel, cons);
            cp.add(methodPanel);
            cons.gridheight = 3;
            cons.gridwidth = 1;
            cons.gridy = 2;
            gb.setConstraints(this.objectsPanel, cons);
            cp.add(this.objectsPanel);
            cons.fill = 0;
            cons.anchor = 18;
            cons.weighty = 0.0;
            cons.gridy = 5;
            cons.gridx = 0;
            gb.setConstraints(buttonPanel, cons);
            this.add(buttonPanel);
            this.listPanel.setPreferredSize(new Dimension(200, 250));
            this.setDefaultCloseOperation(1);
            this.pack();
            okButton.addActionListener(new ActionListener(this){
                final /* synthetic */ MethodFilterSetDialog this$1;
                {
                    this.this$1 = methodFilterSetDialog;
                }

                public void actionPerformed(ActionEvent arg0) {
                    if (MethodFilterSetDialog.access$0(this.this$1).getSelectedIndex() == -1) {
                        JOptionPane.showMessageDialog(this.this$1, "Please select any diagram.", "Filter Error", 0);
                        return;
                    }
                    this.this$1.setVisible(false);
                    int type = 0;
                    if (MethodFilterSetDialog.access$1(this.this$1).isSelected()) {
                        type = 0;
                    } else if (MethodFilterSetDialog.access$2(this.this$1).isSelected()) {
                        type = 1;
                    }
                    this.this$1.getListener().entry(new MethodFilter(MethodFilterSetDialog.access$0(this.this$1).getSelectedString(), type, MethodFilterSetDialog.access$3(this.this$1).getText(), MethodFilterSetDialog.access$4(this.this$1).getCallerPackage(), MethodFilterSetDialog.access$4(this.this$1).getCallerClass(), MethodFilterSetDialog.access$4(this.this$1).getCallerId(), MethodFilterSetDialog.access$4(this.this$1).getCalleePackage(), MethodFilterSetDialog.access$4(this.this$1).getCalleeClass(), MethodFilterSetDialog.access$4(this.this$1).getCalleeId(), MethodFilterSetDialog.access$4(this.this$1).isSamePackageSelected() || MethodFilterSetDialog.access$4(this.this$1).isSameObjectSelected(), MethodFilterSetDialog.access$4(this.this$1).isSameClassSelected() || MethodFilterSetDialog.access$4(this.this$1).isSameObjectSelected(), MethodFilterSetDialog.access$4(this.this$1).isSameIdSelected() || MethodFilterSetDialog.access$4(this.this$1).isSameObjectSelected()));
                    this.this$1.clear();
                }
            });
            cancelButton.addActionListener(new ActionListener(this){
                final /* synthetic */ MethodFilterSetDialog this$1;
                {
                    this.this$1 = methodFilterSetDialog;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.this$1.setVisible(false);
                    this.this$1.clear();
                }
            });
        }

        public void clear() {
            this.methodField.clear();
            this.objectsPanel.clear();
            this.deleteAllButton.setSelected(true);
        }

        public void setVisible(boolean b) {
            if (b) {
                this.setLocationRelativeTo(FilterDialog.this);
            }
            super.setVisible(b);
        }

        public SetMethodListener getListener() {
            return this.listener;
        }

        public void setFilterData(SequenceFilter filter) {
            MethodFilter methodFilter = (MethodFilter)filter;
            this.listPanel.setSelectedObject(filter.getDiagramName());
            if (methodFilter.getTypeName().equals("Delete all.")) {
                this.deleteAllButton.setSelected(true);
            } else if (methodFilter.getTypeName().equals("Delete only.")) {
                this.deleteOnlyButton.setSelected(true);
            }
            this.methodField.setText(methodFilter.getMethodName());
            this.objectsPanel.setCallerPackageName(methodFilter.getCallerPackage());
            this.objectsPanel.setCallerClassName(methodFilter.getCallerClass());
            this.objectsPanel.setCallerIds(methodFilter.getCallerId());
            this.objectsPanel.setCalleePackageName(methodFilter.getCalleePackage());
            this.objectsPanel.setCalleeClassName(methodFilter.getCalleeClass());
            this.objectsPanel.setCalleeIds(methodFilter.getCalleeId());
            this.objectsPanel.setSamePacakge(methodFilter.isSameId());
            this.objectsPanel.setSameClass(methodFilter.isSameClass());
            this.objectsPanel.setSameObject(methodFilter.isSameId());
        }

        static /* synthetic */ TabListPanel access$0(MethodFilterSetDialog methodFilterSetDialog) {
            return methodFilterSetDialog.listPanel;
        }

        static /* synthetic */ JRadioButton access$1(MethodFilterSetDialog methodFilterSetDialog) {
            return methodFilterSetDialog.deleteAllButton;
        }

        static /* synthetic */ JRadioButton access$2(MethodFilterSetDialog methodFilterSetDialog) {
            return methodFilterSetDialog.deleteOnlyButton;
        }

        static /* synthetic */ CheckTextFieldPanel access$3(MethodFilterSetDialog methodFilterSetDialog) {
            return methodFilterSetDialog.methodField;
        }

        static /* synthetic */ CallerCalleePanel access$4(MethodFilterSetDialog methodFilterSetDialog) {
            return methodFilterSetDialog.objectsPanel;
        }
    }

    private class CallerCalleePanel
    extends JPanel {
        private final SetObjectPanel callerObjectPanel;
        private final SetObjectPanel calleeObjectPanel;
        private final JCheckBox samePackage;
        private final JCheckBox sameClass;
        private final JCheckBox sameId;
        private final JCheckBox sameObject;

        CallerCalleePanel() {
            this.callerObjectPanel = new SetObjectPanel();
            this.calleeObjectPanel = new SetObjectPanel();
            this.samePackage = new JCheckBox("Sama pacakge");
            this.sameClass = new JCheckBox("Sama class");
            this.sameId = new JCheckBox("Same id");
            this.sameObject = new JCheckBox("Sama object");
            this.callerObjectPanel.setBorder(BorderFactory.createTitledBorder("Caller Object"));
            this.calleeObjectPanel.setBorder(BorderFactory.createTitledBorder("Callee Object"));
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 0;
            cons.anchor = 18;
            cons.weightx = 1.0;
            cons.weighty = 0.0;
            cons.gridheight = 1;
            cons.gridy = 0;
            cons.gridx = 0;
            cons.gridwidth = 6;
            gb.setConstraints(this.sameObject, cons);
            this.add(this.sameObject);
            cons.gridwidth = 2;
            cons.weightx = 0.0;
            cons.gridy = 1;
            gb.setConstraints(this.samePackage, cons);
            this.add(this.samePackage);
            cons.gridx = 2;
            gb.setConstraints(this.sameClass, cons);
            this.add(this.sameClass);
            cons.gridx = 4;
            cons.weightx = 1.0;
            gb.setConstraints(this.sameId, cons);
            this.add(this.sameId);
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.gridwidth = 3;
            cons.gridheight = 2;
            cons.gridy = 2;
            cons.gridx = 0;
            gb.setConstraints(this.callerObjectPanel, cons);
            this.add(this.callerObjectPanel);
            cons.gridy = 2;
            cons.gridx = 3;
            gb.setConstraints(this.calleeObjectPanel, cons);
            this.add(this.calleeObjectPanel);
            this.samePackage.addActionListener(new ActionListener(this){
                final /* synthetic */ CallerCalleePanel this$1;
                {
                    this.this$1 = callerCalleePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    CallerCalleePanel.access$0(this.this$1).setPackageEditable(!CallerCalleePanel.access$1(this.this$1).isSelected() && !CallerCalleePanel.access$2(this.this$1).isSelected());
                }
            });
            this.sameClass.addActionListener(new ActionListener(this){
                final /* synthetic */ CallerCalleePanel this$1;
                {
                    this.this$1 = callerCalleePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    CallerCalleePanel.access$0(this.this$1).setClassEditable(!CallerCalleePanel.access$1(this.this$1).isSelected() && !CallerCalleePanel.access$3(this.this$1).isSelected());
                }
            });
            this.sameId.addActionListener(new ActionListener(this){
                final /* synthetic */ CallerCalleePanel this$1;
                {
                    this.this$1 = callerCalleePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    CallerCalleePanel.access$0(this.this$1).setIdEditable(!CallerCalleePanel.access$1(this.this$1).isSelected() && !CallerCalleePanel.access$4(this.this$1).isSelected());
                }
            });
            this.sameObject.addActionListener(new ActionListener(this){
                final /* synthetic */ CallerCalleePanel this$1;
                {
                    this.this$1 = callerCalleePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    CallerCalleePanel.access$2(this.this$1).setEnabled(!CallerCalleePanel.access$1(this.this$1).isSelected());
                    CallerCalleePanel.access$3(this.this$1).setEnabled(!CallerCalleePanel.access$1(this.this$1).isSelected());
                    CallerCalleePanel.access$4(this.this$1).setEnabled(!CallerCalleePanel.access$1(this.this$1).isSelected());
                    CallerCalleePanel.access$0(this.this$1).setPackageEditable(!CallerCalleePanel.access$1(this.this$1).isSelected() && !CallerCalleePanel.access$2(this.this$1).isSelected());
                    CallerCalleePanel.access$0(this.this$1).setClassEditable(!CallerCalleePanel.access$1(this.this$1).isSelected() && !CallerCalleePanel.access$3(this.this$1).isSelected());
                    CallerCalleePanel.access$0(this.this$1).setIdEditable(!CallerCalleePanel.access$1(this.this$1).isSelected() && !CallerCalleePanel.access$1(this.this$1).isSelected());
                }
            });
        }

        public void setCalleeIds(Set calleeId) {
            this.calleeObjectPanel.setIds(calleeId);
        }

        public void setCalleeClassName(String calleeClass) {
            this.calleeObjectPanel.setClassName(calleeClass);
        }

        public void setCalleePackageName(String calleePackage) {
            this.calleeObjectPanel.setPackageName(calleePackage);
        }

        public void setCallerIds(Set callerId) {
            this.callerObjectPanel.setIds(callerId);
        }

        public void setCallerClassName(String callerClass) {
            this.callerObjectPanel.setClassName(callerClass);
        }

        public void setCallerPackageName(String callerPackage) {
            this.callerObjectPanel.setPackageName(callerPackage);
        }

        public void clear() {
            this.callerObjectPanel.clear();
            this.calleeObjectPanel.clear();
            this.sameObject.setSelected(false);
            this.samePackage.setSelected(false);
            this.sameClass.setSelected(false);
            this.sameId.setSelected(false);
        }

        public String getCallerPackage() {
            return this.callerObjectPanel.getPackageName();
        }

        public String getCallerClass() {
            return this.callerObjectPanel.getClassName();
        }

        public String getCallerId() {
            return this.callerObjectPanel.getIdString();
        }

        public String getCalleePackage() {
            return this.calleeObjectPanel.getPackageName();
        }

        public String getCalleeClass() {
            return this.calleeObjectPanel.getClassName();
        }

        public String getCalleeId() {
            return this.calleeObjectPanel.getIdString();
        }

        public boolean isSamePackageSelected() {
            return this.samePackage.isSelected();
        }

        public boolean isSameClassSelected() {
            return this.sameClass.isSelected();
        }

        public boolean isSameObjectSelected() {
            return this.sameObject.isSelected();
        }

        public boolean isSameIdSelected() {
            return this.sameId.isSelected();
        }

        public void setSamePacakge(boolean b) {
            this.samePackage.setSelected(b);
        }

        public void setSameClass(boolean b) {
            this.sameClass.setSelected(b);
        }

        public void setSameId(boolean b) {
            this.sameId.setSelected(b);
        }

        public void setSameObject(boolean b) {
            this.sameObject.setSelected(b);
        }

        static /* synthetic */ SetObjectPanel access$0(CallerCalleePanel callerCalleePanel) {
            return callerCalleePanel.calleeObjectPanel;
        }

        static /* synthetic */ JCheckBox access$1(CallerCalleePanel callerCalleePanel) {
            return callerCalleePanel.sameObject;
        }

        static /* synthetic */ JCheckBox access$2(CallerCalleePanel callerCalleePanel) {
            return callerCalleePanel.samePackage;
        }

        static /* synthetic */ JCheckBox access$3(CallerCalleePanel callerCalleePanel) {
            return callerCalleePanel.sameClass;
        }

        static /* synthetic */ JCheckBox access$4(CallerCalleePanel callerCalleePanel) {
            return callerCalleePanel.sameId;
        }
    }

    private class TabListPanel
    extends JPanel
    implements ChangeListener {
        private final JList tabList;

        TabListPanel() {
            LinkedList<String> titleList = new LinkedList<String>();
            int tabNum = SequenceDiagramTabbedPane.getInstance().getTabCount();
            int i = 0;
            while (i < tabNum) {
                titleList.add(SequenceDiagramTabbedPane.getInstance().getTitleAt(i));
                ++i;
            }
            this.tabList = new JList<Object>(titleList.toArray());
            this.tabList.setSelectionMode(0);
            JScrollPane scroll = new JScrollPane(this.tabList);
            SequenceDiagramTabbedPane.getInstance().addChangeListener(this);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 1;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            gb.setConstraints(scroll, cons);
            this.add(scroll);
            scroll.setPreferredSize(new Dimension(200, 250));
        }

        public void stateChanged(ChangeEvent e) {
            LinkedList<String> titleList = new LinkedList<String>();
            int tabNum = SequenceDiagramTabbedPane.getInstance().getTabCount();
            int i = 0;
            while (i < tabNum) {
                titleList.add(SequenceDiagramTabbedPane.getInstance().getTitleAt(i));
                ++i;
            }
            this.tabList.setListData(titleList.toArray());
        }

        public int getSelectedIndex() {
            return this.tabList.getSelectedIndex();
        }

        public String getSelectedString() {
            return (String)this.tabList.getSelectedValue();
        }

        public void setSelectedIndex(int index) {
            this.tabList.setSelectedIndex(index);
        }

        public void setSelectedObject(Object o) {
            this.tabList.setSelectedValue(o, true);
        }
    }

    private class SetObjectPanel
    extends JPanel {
        private CheckTextFieldPanel packageCheck = new CheckTextFieldPanel("Specify pakcage name.", "*");
        private CheckTextFieldPanel classCheck = new CheckTextFieldPanel("Specify class name.", "*");
        private CheckTextFieldPanel idCheck = new CheckTextFieldPanel("Specify object ID.", "*");

        SetObjectPanel() {
            this.packageCheck.setBorder(BorderFactory.createTitledBorder("Package"));
            this.classCheck.setBorder(BorderFactory.createTitledBorder("Class"));
            this.idCheck.setBorder(BorderFactory.createTitledBorder("ID"));
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 2;
            cons.anchor = 18;
            cons.gridx = 0;
            cons.gridwidth = 2;
            cons.weightx = 1.0;
            gb.setConstraints(this.packageCheck, cons);
            this.add(this.packageCheck);
            gb.setConstraints(this.classCheck, cons);
            this.add(this.classCheck);
            gb.setConstraints(this.idCheck, cons);
            this.add(this.idCheck);
            FilterDialog.this.pack();
        }

        public boolean isPackageSpecified() {
            return this.packageCheck.isSelected();
        }

        public boolean isClassSpecified() {
            return this.classCheck.isSelected();
        }

        public boolean isIdSpecified() {
            return this.idCheck.isSelected();
        }

        public String getPackageName() {
            return this.packageCheck.getText();
        }

        public String getClassName() {
            return this.classCheck.getText();
        }

        public String getIdString() {
            return this.idCheck.getText();
        }

        public void clear() {
            this.packageCheck.clear();
            this.classCheck.clear();
            this.idCheck.clear();
            this.setPackageEditable(true);
            this.setClassEditable(true);
            this.setIdEditable(true);
        }

        public void setPackageName(String packageName) {
            if (!packageName.equals("*")) {
                this.packageCheck.setText(packageName);
                this.packageCheck.selected();
                this.packageCheck.check();
            }
        }

        public void setClassName(String className) {
            if (!className.equals("*")) {
                this.classCheck.setText(className);
                this.classCheck.selected();
                this.classCheck.check();
            }
        }

        public void setIds(Set ids) {
            if (!ids.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                Iterator it = ids.iterator();
                while (it.hasNext()) {
                    buffer.append(it.next() + ",");
                }
                this.idCheck.setText(buffer.substring(0, buffer.length() - 1));
                this.idCheck.selected();
                this.idCheck.check();
            }
        }

        public void setPackageEditable(boolean b) {
            this.packageCheck.setEnabled(b);
        }

        public void setClassEditable(boolean b) {
            this.classCheck.setEnabled(b);
        }

        public void setIdEditable(boolean b) {
            this.idCheck.setEnabled(b);
        }
    }
}

