/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencefilter.gui;

import amida.sequencefilter.ISequenceFilter;
import amida.sequencefilter.ObjectDeleteFilter;
import amida.sequencefilter.ObjectUnifyFilter;
import amida.sequencefilter.gui.SequenceFilter;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class ObjectFilter
extends SequenceFilter {
    public static final int OBJECT_DELETE_FILTER = 0;
    public static final int OBJECT_UNIFY_FILTER = 1;
    public static final String DELETE_TYPE_NAME = "Delete";
    public static final String UNIFY_TYPE_NAME = "Unify";
    private int type;
    private String packageName;
    private String className;
    private Set ids = new TreeSet();
    boolean containsAsterisk = false;
    private ISequenceFilter filter;

    public ObjectFilter(String diagramName, int type, String packageName, String className, String idString) {
        super(diagramName);
        this.type = type;
        this.packageName = packageName;
        this.className = className;
        StringTokenizer st = new StringTokenizer(idString, " ,;.()[]{}\t");
        while (st.hasMoreTokens()) {
            try {
                String token = st.nextToken();
                if (token.equals("*")) {
                    this.containsAsterisk = true;
                    continue;
                }
                this.ids.add(Integer.valueOf(token));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (type == 0) {
            this.filter = new ObjectDeleteFilter(packageName, className, this.ids, this.containsAsterisk);
        } else if (type == 1) {
            this.filter = new ObjectUnifyFilter(packageName, className, this.ids, this.containsAsterisk);
        }
    }

    public ISequenceFilter getFilter() {
        return this.filter;
    }

    public String getTypeName() {
        if (this.type == 0) {
            return DELETE_TYPE_NAME;
        }
        if (this.type == 1) {
            return UNIFY_TYPE_NAME;
        }
        return null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public Set getIds() {
        return Collections.unmodifiableSet(this.ids);
    }
}

