/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer;

import amida.library.DataChangeListener;
import amida.node.BlockNode;
import amida.node.CallNode;
import amida.node.CallTree;
import amida.node.LoopNode;
import amida.node.Node;
import amida.node.NodeIterator;
import amida.node.NodeList;
import amida.sequencefilter.IMethodFilter;
import amida.sequencefilter.IPreObjectFilter;
import amida.sequencer.ObjectMap;
import amida.sequencer.RecursiveCallBlock;
import amida.sequencer.SeparateBlock;
import amida.sequencer.Sequence;
import amida.sequencer.SequenceBlock;
import amida.sequencer.SequenceLoop;
import amida.sequencer.SequenceObject;
import amida.sequencer.SequenceSelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class SequenceModel
implements DataChangeListener {
    private static boolean allClassName = false;
    private List dataChangeListeners = new LinkedList();
    private CallTree callTree;
    private Node targetNode;
    private NodeList targetNodeList;
    private SequenceSelectionModel selectionModel = new SequenceSelectionModel();
    private List preObjectFilterList = new LinkedList();
    private List preMethodFilterList = new LinkedList();
    private List afterMethodFilterList = new LinkedList();
    private List afterObjectFilterList = new LinkedList();
    private List objectList;
    private List sequenceList;
    private List loopList;
    private List blockList;
    private List tmpObjectList;
    private List tmpSequenceList;
    private List tmpLoopList;
    private List tmpBlockList;
    private int tmpMaxLoopDepth;
    private int tmpMaxCallStackLevel;
    private int tmpMaxBlockDepth;
    private final List sequenceIndexExchangeList = new ArrayList();
    private final List objectIndexExchangeList = new ArrayList();
    private int maxLoopDepth = 0;
    private int maxBlockDepth = 0;
    private int maxCallStackLevel = 0;
    private ObjectMap objectMap = new ObjectMap();
    private Stack recursiveStack = new Stack();
    private Stack loopStack = new Stack();
    private int sequenceCount = 0;

    public SequenceModel(CallTree tree) {
        this.callTree = tree;
        tree.addDataChangeListener(this);
        this.renew();
    }

    public SequenceModel(Node node) {
        this.targetNode = node;
        this.callTree = node.getCallTree();
        this.callTree.addDataChangeListener(this);
        this.renew();
    }

    public SequenceModel(NodeList list) {
        this.targetNodeList = list;
        this.callTree = list.getCallTree();
        this.callTree.addDataChangeListener(this);
        this.renew();
    }

    public void renew() {
        if (this.targetNodeList == null && this.targetNode == null && this.callTree.getTopNodeList() == null) {
            return;
        }
        this.getSelectionModel().clearAllSelection();
        this.tmpLoopList = new ArrayList();
        this.tmpObjectList = new ArrayList();
        this.tmpSequenceList = new ArrayList();
        this.tmpBlockList = new ArrayList();
        this.tmpMaxLoopDepth = 0;
        this.tmpMaxBlockDepth = 0;
        this.tmpMaxCallStackLevel = 0;
        this.loopStack.clear();
        this.objectMap.clear();
        this.sequenceCount = 0;
        NodeList nodes = null;
        Node node = null;
        if (this.targetNodeList != null) {
            nodes = this.targetNodeList;
        } else if (this.targetNode != null) {
            node = this.targetNode;
        } else {
            nodes = this.callTree.getTopNodeList();
        }
        if (node != null) {
            this.objectMap.makeObjectGroupes(node, this.preObjectFilterList);
            this.makeSequenceModel(node, null, this.loopStack, 0);
        } else {
            this.objectMap.makeObjectGroupes(nodes, this.preObjectFilterList);
            this.makeSequenceModel(nodes, null, this.loopStack, 0);
        }
        this.reflectNewData();
        this.fireDataChange();
    }

    private void makeSequenceModel(NodeList list, SequenceObject callParent, Stack loopStack, int blockDepth) {
        NodeIterator it = list.nodeIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            this.makeSequenceModel(node, callParent, loopStack, blockDepth);
        }
    }

    private void makeSequenceModel(Node node, SequenceObject callParent, Stack loopStack, int blockDepth) {
        if (node instanceof CallNode) {
            CallNode call = (CallNode)node;
            SequenceObject object = this.objectMap.get(call);
            if (object == null) {
                return;
            }
            if (call.isConstructor() && object.getMadeIndex() == 0) {
                object.renewClassName(call);
            }
            Sequence newSequence = call.isRecursive() && !call.hasChildren() ? new Sequence(call, callParent, object, 3, this.sequenceCount) : new Sequence(call, callParent, object, 0, this.sequenceCount);
            int filtered = 0;
            Iterator it = this.preMethodFilterList.iterator();
            while (it.hasNext()) {
                IMethodFilter filter = (IMethodFilter)it.next();
                int tmp = filter.filter(newSequence);
                if (tmp > filtered) {
                    filtered = tmp;
                }
                if (filtered == 1) break;
            }
            if (filtered == 2) {
                this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth);
            } else if (filtered == 0) {
                boolean isNewObject = false;
                if (object.getIndex() <= 0) {
                    object.setAppearanceIndex(this.tmpObjectList.size() + 1);
                    isNewObject = true;
                }
                ++this.sequenceCount;
                if (isNewObject) {
                    this.tmpObjectList.add(object);
                }
                this.tmpSequenceList.add(newSequence);
                if (callParent != null) {
                    callParent.addCallSequence(newSequence);
                }
                if (!call.isRecursive() || call.hasChildren()) {
                    object.call(newSequence, this.tmpSequenceList.size());
                }
                if (call.isBranch()) {
                    newSequence.setBranch(true);
                }
                if (object.getLevel() > this.tmpMaxCallStackLevel) {
                    this.tmpMaxCallStackLevel = object.getLevel();
                }
                if (!object.getIds().contains(new Integer(0)) && object.getMadeIndex() == 0) {
                    object.make(this.tmpSequenceList.size());
                }
                int tmpBlockDepth = 0;
                if (call.isRecursive() && call.hasChildren()) {
                    tmpBlockDepth = blockDepth++;
                }
                this.makeSequenceModel(node.getChildren(), object, loopStack, blockDepth);
                object.used(this.sequenceCount);
                Sequence newSequence2 = null;
                newSequence2 = call.getExitMode() == 2 ? (!call.isRecursive() || call.hasChildren() ? new Sequence(call, object, callParent, 5, this.sequenceCount++) : new Sequence(call, object, callParent, 6, this.sequenceCount++)) : (call.getReturnType().equals("void") || !call.isEnded() ? new Sequence(call, object, callParent, 2, this.sequenceCount++) : (call.isRecursive() && !call.hasChildren() ? new Sequence(call, object, callParent, 4, this.sequenceCount++) : new Sequence(call, object, callParent, 1, this.sequenceCount++)));
                this.tmpSequenceList.add(newSequence2);
                if (callParent != null) {
                    callParent.addCallSequence(newSequence2);
                }
                newSequence.setPareSequence(newSequence2);
                newSequence2.setPareSequence(newSequence);
                if (!call.isRecursive() || call.hasChildren()) {
                    object.ret(newSequence2, this.tmpSequenceList.size() - 1);
                }
                if (call.isRecursive() && call.hasChildren()) {
                    RecursiveCallBlock recursiveBlock = new RecursiveCallBlock(tmpBlockDepth, callParent);
                    recursiveBlock.setStartIndex(newSequence.getIndex());
                    recursiveBlock.setEndIndex(newSequence2.getIndex());
                    recursiveBlock.setSequenceList(new ArrayList(this.tmpSequenceList.subList(newSequence.getIndex(), newSequence2.getIndex() + 1)));
                    this.tmpBlockList.add(recursiveBlock);
                }
            }
        } else if (node instanceof LoopNode) {
            int loopStart = this.tmpSequenceList.size();
            loopStack.push(callParent);
            this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth);
            loopStack.pop();
            int loopEnd = this.tmpSequenceList.size();
            if (loopStart != loopEnd) {
                Iterator stackEntry = loopStack.iterator();
                int count = 1;
                while (stackEntry.hasNext()) {
                    if (callParent != stackEntry.next()) continue;
                    ++count;
                }
                if (count > this.tmpMaxLoopDepth) {
                    this.tmpMaxLoopDepth = count;
                }
                this.tmpLoopList.add(new SequenceLoop((LoopNode)node, loopStart, loopEnd - 1, callParent, count));
            }
        } else if (node instanceof BlockNode) {
            BlockNode block = (BlockNode)node;
            if (block.hasChildren()) {
                SeparateBlock separateBlock = new SeparateBlock(block, blockDepth, callParent);
                int start = this.sequenceCount;
                separateBlock.setStartIndex(start);
                if (this.tmpMaxBlockDepth < ++blockDepth) {
                    this.tmpMaxBlockDepth = blockDepth;
                }
                this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth);
                int end = this.sequenceCount - 1;
                separateBlock.setEndIndex(end);
                separateBlock.setSequenceList(new ArrayList(this.tmpSequenceList.subList(start, end)));
                this.tmpBlockList.add(separateBlock);
            } else {
                SeparateBlock separateBlock = new SeparateBlock(block, blockDepth, callParent);
                separateBlock.setStartIndex(this.sequenceCount);
                separateBlock.setEndIndex(this.sequenceCount);
                separateBlock.setSequenceList(new ArrayList());
                this.tmpBlockList.add(separateBlock);
                this.tmpSequenceList.add(new Sequence(null, callParent, callParent, 2, this.sequenceCount++));
            }
        } else {
            this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth);
        }
    }

    private synchronized void reflectNewData() {
        this.loopList = this.tmpLoopList;
        this.objectList = this.tmpObjectList;
        this.sequenceList = this.tmpSequenceList;
        this.blockList = this.tmpBlockList;
        this.maxLoopDepth = this.tmpMaxLoopDepth;
        this.maxBlockDepth = this.tmpMaxBlockDepth;
        this.maxCallStackLevel = this.tmpMaxCallStackLevel;
    }

    public synchronized List getSequenceList() {
        return Collections.unmodifiableList(this.sequenceList);
    }

    public synchronized Sequence getSequence(int i) {
        return (Sequence)this.sequenceList.get(i);
    }

    public synchronized int getSequenceNum() {
        return this.sequenceList.size();
    }

    public synchronized List getObjectList() {
        return Collections.unmodifiableList(this.objectList);
    }

    public synchronized SequenceObject getObject(int i) {
        return (SequenceObject)this.objectList.get(i);
    }

    public synchronized int getObjectNum() {
        return this.objectList.size();
    }

    public synchronized List getLoopList() {
        return Collections.unmodifiableList(this.loopList);
    }

    public synchronized SequenceLoop getLoop(int i) {
        return (SequenceLoop)this.loopList.get(i);
    }

    public synchronized int getLoopNum() {
        return this.loopList.size();
    }

    public synchronized List getBlockList() {
        return Collections.unmodifiableList(this.blockList);
    }

    public synchronized SequenceBlock getBlock(int i) {
        return (SequenceBlock)this.blockList.get(i);
    }

    public synchronized int getBlockNum() {
        return this.blockList.size();
    }

    public synchronized void sortObject(Comparator comp) {
        Collections.sort(this.objectList, comp);
        ListIterator it = this.objectList.listIterator();
        while (it.hasNext()) {
            ((SequenceObject)it.next()).setIndex(it.nextIndex());
        }
        this.fireDataChange();
    }

    public synchronized int getMaxCallDepth() {
        return this.maxCallStackLevel;
    }

    public synchronized int getMaxLoopDepth() {
        return this.maxLoopDepth;
    }

    public void dataChanged() {
        this.renew();
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.add(listener);
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.remove(listener);
    }

    public void fireDataChange() {
        Iterator it = this.dataChangeListeners.iterator();
        while (it.hasNext()) {
            DataChangeListener listener = (DataChangeListener)it.next();
            listener.dataChanged();
        }
    }

    public SequenceSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SequenceSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void selectionChanged() {
        this.renew();
    }

    public CallTree getCallTree() {
        return this.callTree;
    }

    public int getMaxBlockDepth() {
        return this.maxBlockDepth;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public NodeList getTargetNodeList() {
        return this.targetNodeList;
    }

    public void addPreObjectFilter(IPreObjectFilter filter) {
        this.preObjectFilterList.add(filter);
    }

    public void remvoePreObjectFilter(IPreObjectFilter filter) {
        this.preObjectFilterList.remove(filter);
    }

    public void addPreMethodFilter(IMethodFilter filter) {
        this.preMethodFilterList.add(filter);
    }

    public void removePreMethodFilter(IMethodFilter filter) {
        this.preMethodFilterList.add(filter);
    }

    public void clearAllFilters() {
        this.preObjectFilterList.clear();
        this.preMethodFilterList.clear();
        this.afterMethodFilterList.clear();
        this.afterObjectFilterList.clear();
    }
}

