/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer;

import amida.library.SelectionChangeListener;
import amida.sequencer.Called;
import amida.sequencer.ISequenceElement;
import amida.sequencer.Sequence;
import amida.sequencer.SequenceBlock;
import amida.sequencer.SequenceLoop;
import amida.sequencer.SequenceObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SequenceSelectionModel {
    private Set selectedSequenceIndex = new TreeSet();
    private Set selectedObjectIndex = new TreeSet();
    private Set selectedBlock = new HashSet();
    private Set selectedCalled = new HashSet();
    private Set selectedLoops = new HashSet();
    private List selectionListeners = new LinkedList();

    public Set getSelectedSequenceIndex() {
        return this.selectedSequenceIndex;
    }

    public void setSelectedSequence(int i) {
        this.selectedSequenceIndex.add(new Integer(i));
        this.fireSelectionChanged();
    }

    public void clearSelectedSequence() {
        this.selectedSequenceIndex.clear();
        this.fireSelectionChanged();
    }

    public Set getSelectedObjectIndex() {
        return this.selectedObjectIndex;
    }

    public void setSelectedObject(int i) {
        this.selectedObjectIndex.add(new Integer(i));
        this.fireSelectionChanged();
    }

    public void clearSelectedObject() {
        this.selectedObjectIndex.clear();
        this.fireSelectionChanged();
    }

    public Set getSelectedLoops() {
        return this.selectedLoops;
    }

    public void setSelectedLoop(SequenceLoop loop) {
        this.selectedLoops.add(loop);
        this.fireSelectionChanged();
    }

    public void clearSelectedLoop() {
        this.selectedLoops.clear();
        this.fireSelectionChanged();
    }

    public Set getSeletectedBlock() {
        return this.selectedBlock;
    }

    public void setSelectedBlock(SequenceBlock block) {
        this.selectedBlock.add(block);
        this.fireSelectionChanged();
    }

    public void clearSelectedBlock() {
        this.selectedBlock.clear();
        this.fireSelectionChanged();
    }

    public Set getSelectedCalled() {
        return this.selectedCalled;
    }

    public void setSelectedCalled(Called c) {
        this.selectedCalled.add(c);
        this.fireSelectionChanged();
    }

    public void clearSelectedCalled() {
        this.selectedCalled.clear();
        this.fireSelectionChanged();
    }

    public void clearAllSelection() {
        this.selectedSequenceIndex.clear();
        this.selectedObjectIndex.clear();
        this.selectedBlock.clear();
        this.selectedLoops.clear();
        this.selectedCalled.clear();
        this.fireSelectionChanged();
    }

    public void selectElement(ISequenceElement element) {
        if (element instanceof Called) {
            this.clearAllSelection();
            this.setSelectedCalled((Called)element);
        } else if (!(element instanceof SequenceObject)) {
            if (element instanceof Sequence) {
                this.clearAllSelection();
                this.setSelectedSequence(((Sequence)element).getIndex());
            } else if (element instanceof SequenceBlock) {
                this.clearAllSelection();
                this.setSelectedBlock((SequenceBlock)element);
            } else if (element instanceof SequenceLoop) {
                this.clearAllSelection();
                this.setSelectedLoop((SequenceLoop)element);
            }
        }
    }

    public void addSelectionListener(SelectionChangeListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionChangeListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void fireSelectionChanged() {
        Iterator it = this.selectionListeners.iterator();
        while (it.hasNext()) {
            SelectionChangeListener listener = (SelectionChangeListener)it.next();
            listener.selectionChanged();
        }
    }
}

