/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.sequencer.ISequenceElement;
import java.awt.Point;
import java.awt.Rectangle;

public class SelectableElement
implements Comparable {
    public static final int SEQUENCE_LINE = 0;
    public static final int SEQUENCE_STRING = 1;
    public static final int CALLED = 2;
    public static final int LOOP = 3;
    public static final int BLOCK = 4;
    public static final int PRIORITY_NUM = 5;
    private Rectangle range;
    private ISequenceElement element;
    private int priority;

    public SelectableElement(Rectangle range, ISequenceElement element, int priority) {
        this.range = range;
        this.element = element;
        this.priority = priority;
    }

    public SelectableElement(Rectangle range, ISequenceElement element) {
        this.range = range;
        this.element = element;
        this.priority = 2;
    }

    public boolean isInRange(Point p) {
        return this.range.getX() <= (double)p.x && this.range.getX() + this.range.getWidth() >= (double)p.x && this.range.getY() <= (double)p.y && this.range.getY() + this.range.getHeight() >= (double)p.y;
    }

    public boolean isInRange(int x, int y) {
        return this.range.getX() <= (double)x && this.range.getX() + this.range.getWidth() <= (double)x && this.range.getY() <= (double)y && this.range.getY() + this.range.getHeight() <= (double)y;
    }

    public Rectangle getRange() {
        return this.range;
    }

    public ISequenceElement getElement() {
        return this.element;
    }

    public int getPriority() {
        return this.priority;
    }

    public int compareTo(Object o) {
        if (!(o instanceof SelectableElement)) {
            return 1;
        }
        SelectableElement element = (SelectableElement)o;
        int large = (int)(this.getRange().getWidth() + this.getRange().getHeight() - element.getRange().getWidth() - element.getRange().getHeight());
        if (large != 0) {
            return large;
        }
        int pointX = (int)(this.getRange().getX() - element.getRange().getX());
        if (pointX != 0) {
            return pointX;
        }
        return (int)(this.getRange().getY() - element.getRange().getY());
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }
}

