/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.sequencer.Sequence;
import amida.sequencer.SequenceModel;
import amida.sequencer.SequenceObject;
import amida.sequencer.gui.SequenceDiagramCanvas;
import amida.sequencer.gui.SequenceDiagramTabbedPane;
import amida.sequencer.gui.SequenceDiagramsAdjuster;
import amida.sequencer.gui.SequenceObjectCanvas;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class SequenceDiagramPanel
extends JPanel {
    public static final int DOWN_SEARCH = 0;
    public static final int UP_SEARCH = 1;
    public static final int SEARCH_METHOD = 0;
    public static final int SEARCH_OBJECT = 1;
    private final SequenceDiagramCanvas sdc = new SequenceDiagramCanvas();
    private final SequenceObjectCanvas soc = new SequenceObjectCanvas();
    private SequenceDiagramsAdjuster adjuster = new SequenceDiagramsAdjuster();
    private String name = "";
    private String prevSerchText;
    private int prevTarget = 0;

    protected SequenceDiagramPanel(SequenceModel model, String name) {
        this.name = name;
        JScrollPane sdcScroll = new JScrollPane(this.sdc);
        sdcScroll.getVerticalScrollBar().setUnitIncrement(100);
        sdcScroll.getHorizontalScrollBar().setUnitIncrement(100);
        JSplitPane sequenceSplit = new JSplitPane(0, true);
        sequenceSplit.setDividerSize(2);
        sequenceSplit.setLeftComponent(this.soc);
        sequenceSplit.setRightComponent(sdcScroll);
        this.adjuster.setDiagramCanvas(this.sdc);
        this.adjuster.setObjectCanvas(this.soc);
        this.setModel(model);
        Dimension size = SequenceDiagramTabbedPane.getInstance().getSize();
        this.setPreferredSize(size);
        this.soc.setPreferredSize(new Dimension((int)size.getWidth(), SequenceDiagramsAdjuster.MARGIN.top + SequenceDiagramsAdjuster.OBJECT_HEIGHT + 3));
        sdcScroll.setPreferredSize(new Dimension((int)size.getWidth(), (int)size.getHeight() - 300));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        layout.setConstraints(sequenceSplit, c);
        this.add(sequenceSplit);
        sdcScroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                SequenceDiagramPanel.this.sdc.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 114) {
                    if (e.isShiftDown()) {
                        SequenceDiagramPanel.this.search(1);
                    } else {
                        SequenceDiagramPanel.this.search(0);
                    }
                }
                SequenceDiagramPanel.this.repaint();
            }
        });
    }

    public String getDiagramName() {
        return this.name;
    }

    public void setDiagramName(String name) {
        this.name = name;
    }

    public SequenceDiagramsAdjuster getAdjuster() {
        return this.adjuster;
    }

    public SequenceDiagramCanvas getSdc() {
        return this.sdc;
    }

    public SequenceObjectCanvas getSoc() {
        return this.soc;
    }

    public SequenceModel getModel() {
        return this.adjuster.getModel();
    }

    public void setModel(SequenceModel model) {
        this.adjuster.setModel(model);
    }

    public String getPrevSerchText() {
        return this.prevSerchText;
    }

    public int getPrevTarget() {
        return this.prevTarget;
    }

    public void search(int direction) {
        this.search(this.getPrevSerchText(), this.getPrevTarget(), direction);
    }

    public void search(String text, int target, int direction) {
        block13: {
            SequenceModel model;
            block12: {
                this.prevSerchText = text;
                this.prevTarget = target;
                model = this.getModel();
                if (target != 0) break block12;
                Set indexes = model.getSelectionModel().getSelectedSequenceIndex();
                int currentSelectedIndex = indexes.isEmpty() ? (direction == 0 ? -1 : model.getSequenceNum()) : (Integer)indexes.iterator().next();
                if (direction == 0) {
                    int i = currentSelectedIndex + 1;
                    while (i < model.getSequenceNum()) {
                        Sequence sequence = model.getSequence(i);
                        if ((sequence.getType() == 0 || sequence.getType() == 3) && (String.valueOf(sequence.getNode().getMethodName()) + sequence.getNode().getFullArgs()).indexOf(text) != -1) {
                            model.getSelectionModel().clearAllSelection();
                            model.getSelectionModel().setSelectedSequence(i);
                            this.sdc.scroll(sequence.getEnd().getIndex(), i);
                            this.requestFocusInWindow();
                            return;
                        }
                        ++i;
                    }
                } else {
                    int i = currentSelectedIndex - 1;
                    while (i >= 0) {
                        Sequence sequence = model.getSequence(i);
                        if ((sequence.getType() == 0 || sequence.getType() == 3) && (String.valueOf(sequence.getNode().getMethodName()) + sequence.getNode().getFullArgs()).indexOf(text) != -1) {
                            model.getSelectionModel().clearAllSelection();
                            model.getSelectionModel().setSelectedSequence(i);
                            this.sdc.scroll(sequence.getEnd().getIndex(), i);
                            this.requestFocusInWindow();
                            return;
                        }
                        --i;
                    }
                }
                break block13;
            }
            if (target != 1) break block13;
            Set indexes = model.getSelectionModel().getSelectedObjectIndex();
            int currentSelectedIndex = indexes.isEmpty() ? (direction == 0 ? -1 : model.getObjectNum()) : (Integer)indexes.iterator().next();
            if (direction == 0) {
                int i = currentSelectedIndex + 1;
                while (i < model.getObjectNum()) {
                    SequenceObject object = model.getObject(i);
                    if ((String.valueOf(object.getPackageName()) + object.getClassName() + object.getIds().toString()).indexOf(text) != -1) {
                        model.getSelectionModel().clearAllSelection();
                        model.getSelectionModel().setSelectedObject(i);
                        this.sdc.scroll(i, -1);
                        this.requestFocusInWindow();
                        return;
                    }
                    ++i;
                }
            } else {
                int i = currentSelectedIndex - 1;
                while (i >= 0) {
                    SequenceObject object = model.getObject(i);
                    if ((String.valueOf(object.getPackageName()) + object.getClassName() + object.getIds()).indexOf(text) != -1) {
                        model.getSelectionModel().clearAllSelection();
                        model.getSelectionModel().setSelectedObject(i);
                        this.sdc.scroll(i, -1);
                        this.requestFocusInWindow();
                        return;
                    }
                    --i;
                }
            }
        }
    }
}

