/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.sequencer.SequenceModel;
import amida.sequencer.gui.SequenceDiagramCanvas;
import amida.sequencer.gui.SequenceMapCanvas;
import amida.sequencer.gui.SequenceObjectCanvas;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JScrollPane;

public class SequenceDiagramsAdjuster {
    protected static Insets MARGIN = new Insets(5, 20, 10, 10);
    protected static int MINIMUM_OBJECTS_SPACE = 10;
    protected static int OBJECT_WIDTH = 100;
    protected static int OBJECT_HEIGHT = 70;
    protected static int SEQUENCE_SPACE = 30;
    protected static int CALLED_SIZE = 6;
    private SequenceDiagramCanvas sdc;
    private SequenceObjectCanvas soc;
    private SequenceMapCanvas smc;
    private SequenceModel model;
    private MouseListener smcMouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            Insets margin = SequenceMapCanvas.MARGIN;
            SequenceDiagramsAdjuster.this.moveSdc((p.getX() - (double)margin.left) / (double)SequenceDiagramsAdjuster.this.smc.getXRate(), (p.getY() - (double)margin.top) / (double)SequenceDiagramsAdjuster.this.smc.getYRate() + 1.0);
        }
    };
    private MouseMotionListener smcMouseMotionListener = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            Insets margin = SequenceMapCanvas.MARGIN;
            SequenceDiagramsAdjuster.this.moveSdc((p.getX() - (double)margin.left) / (double)SequenceDiagramsAdjuster.this.smc.getXRate(), (p.getY() - (double)margin.top) / (double)SequenceDiagramsAdjuster.this.smc.getYRate() + 1.0);
        }
    };
    private AdjustmentListener sdcScrollListener = new AdjustmentListener(){

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (SequenceDiagramsAdjuster.this.smc != null) {
                SequenceDiagramsAdjuster.this.smc.repaint();
            }
            if (SequenceDiagramsAdjuster.this.soc != null) {
                SequenceDiagramsAdjuster.this.soc.repaint();
            }
        }
    };

    protected int getPreferredObjectsSpace() {
        if (this.model == null) {
            return MINIMUM_OBJECTS_SPACE;
        }
        int space = this.model.getMaxCallDepth() * CALLED_SIZE;
        if (space > MINIMUM_OBJECTS_SPACE) {
            return space;
        }
        return MINIMUM_OBJECTS_SPACE;
    }

    protected void setDiagramCanvas(SequenceDiagramCanvas _sdc) {
        this.sdc = _sdc;
        JScrollPane diagramScroll = this.getParentJScrollPane(this.sdc);
        if (diagramScroll != null) {
            diagramScroll.getHorizontalScrollBar().addAdjustmentListener(this.sdcScrollListener);
            diagramScroll.getVerticalScrollBar().addAdjustmentListener(this.sdcScrollListener);
        }
        this.sdc.setSequenceDiagramsAdjuster(this);
    }

    protected void setObjectCanvas(SequenceObjectCanvas soc) {
        this.soc = soc;
        soc.setSequenceDiagramsAdjuster(this);
    }

    protected void setMapCanvas(SequenceMapCanvas _smc) {
        this.smc = _smc;
        if (this.smc != null) {
            this.smc.setModel(this.getModel());
            this.smc.addMouseListener(this.smcMouseListener);
            this.smc.addMouseMotionListener(this.smcMouseMotionListener);
            this.smc.setSequenceDiagramsAdjuster(this);
        }
    }

    protected void removeMapCanvas() {
        if (this.smc != null) {
            this.smc.removeMouseListener(this.smcMouseListener);
            this.smc.removeMouseMotionListener(this.smcMouseMotionListener);
            this.smc.setSequenceDiagramsAdjuster(null);
            this.smc = null;
        }
    }

    protected Rectangle getDiagramCanvasViewRange() {
        return this.sdc.getViewRange();
    }

    public void moveSdc(double objectNum, double sequenceNum) {
        if (this.sdc == null) {
            return;
        }
        this.sdc.scroll((int)objectNum, (int)sequenceNum);
    }

    public Rectangle translateCoordinates(Rectangle sdcCoordinates) {
        double xrate = (double)this.smc.getXRate() / (double)(this.getPreferredObjectsSpace() + OBJECT_WIDTH);
        double yrate = (double)this.smc.getYRate() / (double)SEQUENCE_SPACE;
        int x = (int)((double)sdcCoordinates.x * xrate);
        int y = (int)((double)sdcCoordinates.y * yrate);
        int width = (int)((double)sdcCoordinates.width * xrate);
        int height = (int)((double)sdcCoordinates.height * yrate);
        return new Rectangle(x, y, width, height);
    }

    private JScrollPane getParentJScrollPane(Component comp) {
        while ((comp = comp.getParent()) != null && !(comp instanceof JScrollPane)) {
        }
        if (comp != null) {
            return (JScrollPane)comp;
        }
        return null;
    }

    public SequenceModel getModel() {
        return this.model;
    }

    public void setModel(SequenceModel model) {
        this.model = model;
        if (this.sdc != null) {
            this.sdc.setModel(model);
        }
        if (this.smc != null) {
            this.smc.setModel(model);
        }
        if (this.soc != null) {
            this.soc.setModel(model);
        }
    }
}

