/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.library.DataChangeListener;
import amida.library.SelectionChangeListener;
import amida.node.LoopNode;
import amida.node.MethodMissingLoopNode;
import amida.node.ObjectDifferenceLoopNode;
import amida.sequencer.Called;
import amida.sequencer.Sequence;
import amida.sequencer.SequenceBlock;
import amida.sequencer.SequenceLoop;
import amida.sequencer.SequenceModel;
import amida.sequencer.SequenceObject;
import amida.sequencer.gui.SequenceDiagramsAdjuster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SequenceMapCanvas
extends JPanel
implements DataChangeListener,
SelectionChangeListener {
    protected static final Insets MARGIN = new Insets(5, 5, 5, 5);
    private static final SequenceMapCanvas singleton = new SequenceMapCanvas();
    private int autoScrollDistance = 10;
    private JScrollPane scrollPane;
    private SequenceDiagramsAdjuster adjuster;
    private SequenceModel model;
    private int xRate = 3;
    private int yRate = 2;

    private SequenceMapCanvas() {
        this.setBackground(Color.white);
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent event) {
                int length;
                int x = event.getX();
                int y = event.getY();
                if (SequenceMapCanvas.this.scrollPane == null) {
                    return;
                }
                Rectangle rect = SequenceMapCanvas.this.scrollPane.getViewport().getViewRect();
                if (rect.x + SequenceMapCanvas.this.autoScrollDistance > x) {
                    length = x - (rect.x + SequenceMapCanvas.this.autoScrollDistance);
                    SequenceMapCanvas.this.scrollPane.getHorizontalScrollBar().setValue(SequenceMapCanvas.this.scrollPane.getHorizontalScrollBar().getValue() + length);
                } else if (rect.x + rect.width - SequenceMapCanvas.this.autoScrollDistance < x) {
                    length = x - (rect.x + rect.width - SequenceMapCanvas.this.autoScrollDistance);
                    SequenceMapCanvas.this.scrollPane.getHorizontalScrollBar().setValue(SequenceMapCanvas.this.scrollPane.getHorizontalScrollBar().getValue() + length);
                }
                if (rect.y + SequenceMapCanvas.this.autoScrollDistance > y) {
                    length = y - (rect.y + SequenceMapCanvas.this.autoScrollDistance);
                    SequenceMapCanvas.this.scrollPane.getVerticalScrollBar().setValue(SequenceMapCanvas.this.scrollPane.getVerticalScrollBar().getValue() + length);
                } else if (rect.y + rect.height - SequenceMapCanvas.this.autoScrollDistance < y) {
                    length = y - (rect.y + rect.height - SequenceMapCanvas.this.autoScrollDistance);
                    SequenceMapCanvas.this.scrollPane.getVerticalScrollBar().setValue(SequenceMapCanvas.this.scrollPane.getVerticalScrollBar().getValue() + length);
                }
            }

            public void mouseMoved(MouseEvent arg0) {
            }
        });
    }

    public static SequenceMapCanvas getInstance() {
        return singleton;
    }

    public void setScrollPane(JScrollPane scroll) {
        this.scrollPane = scroll;
    }

    public SequenceMapCanvas(SequenceModel model) {
        this.setBackground(Color.white);
        this.setModel(model);
    }

    public void setSequenceDiagramsAdjuster(SequenceDiagramsAdjuster adjuster) {
        this.adjuster = adjuster;
    }

    public SequenceModel getModel() {
        if (this.adjuster != null) {
            return this.adjuster.getModel();
        }
        return this.model;
    }

    public void setModel(SequenceModel model) {
        SequenceModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeDataChangeListener(this);
        }
        this.model = model;
        if (model != null) {
            model.addDataChangeListener(this);
            model.getSelectionModel().addSelectionListener(this);
        }
        this.resize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        super.paint(g);
        SequenceModel model = this.getModel();
        if (model == null) {
            return;
        }
        SequenceModel sequenceModel = model;
        synchronized (sequenceModel) {
            int end;
            int start;
            int i = 0;
            while (i < model.getBlockNum()) {
                SequenceBlock block = model.getBlock(i);
                start = block.getStartIndex();
                end = block.getEndIndex();
                int xMin = 0;
                int xMax = 0;
                Iterator it2 = block.getSequenceList().iterator();
                if (it2.hasNext()) {
                    Sequence sequence = (Sequence)it2.next();
                    xMin = sequence.getStartIndex();
                    xMax = sequence.getEndIndex();
                    while (it2.hasNext()) {
                        sequence = (Sequence)it2.next();
                        if (sequence.getType() == 2 || !it2.hasNext()) continue;
                        int tmp = sequence.getEndIndex();
                        if (sequence.getType() == 3) {
                            tmp = sequence.getStartIndex() + 1;
                        }
                        if (tmp < xMin) {
                            xMin = tmp;
                        }
                        if (tmp <= xMax) continue;
                        xMax = tmp;
                    }
                    g.drawRect(SequenceMapCanvas.MARGIN.left + xMin * this.xRate, SequenceMapCanvas.MARGIN.top + start * this.yRate, (xMax - xMin) * this.xRate, (end - start + 1) * this.yRate);
                }
                ++i;
            }
            i = 0;
            while (i < model.getSequenceNum()) {
                int end2;
                int start2;
                boolean isSelected;
                Sequence sequence = model.getSequence(i);
                boolean bl = isSelected = this.sequenceIsSelected(i) || this.sequenceIsSelected(sequence.getPareSequence().getIndex());
                if (sequence.getType() != 2 && (start2 = sequence.getStartIndex()) != (end2 = sequence.getEndIndex())) {
                    Color backupColor = g.getColor();
                    if (isSelected) {
                        g.setColor(Color.BLUE);
                    }
                    g.drawLine(SequenceMapCanvas.MARGIN.left + start2 * this.xRate, SequenceMapCanvas.MARGIN.top + (i + 1) * this.yRate, SequenceMapCanvas.MARGIN.left + end2 * this.xRate, SequenceMapCanvas.MARGIN.top + (i + 1) * this.yRate);
                    g.setColor(backupColor);
                }
                ++i;
            }
            i = 0;
            while (i < model.getLoopNum()) {
                SequenceLoop loop = model.getLoop(i);
                start = loop.getStart();
                end = loop.getEnd();
                SequenceObject object = loop.getParentObject();
                int objectIndex = object != null ? object.getIndex() : 0;
                LoopNode node = loop.getNode();
                if (node instanceof ObjectDifferenceLoopNode) {
                    g.setColor(Color.BLUE);
                } else if (node instanceof MethodMissingLoopNode) {
                    g.setColor(Color.RED);
                }
                g.drawLine(SequenceMapCanvas.MARGIN.left + objectIndex * this.xRate + loop.getDepth() - 1, SequenceMapCanvas.MARGIN.top + start * this.yRate, SequenceMapCanvas.MARGIN.left + objectIndex * this.xRate + loop.getDepth() - 1, SequenceMapCanvas.MARGIN.top + end * this.yRate);
                ++i;
            }
            if (this.adjuster != null) {
                Color backupColor = g.getColor();
                g.setColor(Color.RED);
                Rectangle viewRange = this.adjuster.translateCoordinates(this.adjuster.getDiagramCanvasViewRange());
                g.drawRect(SequenceMapCanvas.MARGIN.left + viewRange.x, SequenceMapCanvas.MARGIN.top + viewRange.y, viewRange.width, viewRange.height);
                Rectangle myViewRange = this.scrollPane.getViewport().getViewRect();
                if (myViewRange.getX() > (double)(SequenceMapCanvas.MARGIN.left + viewRange.x) || myViewRange.getX() + myViewRange.getWidth() < (double)(SequenceMapCanvas.MARGIN.left + viewRange.x + viewRange.width) || myViewRange.getY() > (double)(SequenceMapCanvas.MARGIN.top + viewRange.y) || myViewRange.getY() + myViewRange.getHeight() < (double)(SequenceMapCanvas.MARGIN.top + viewRange.y + viewRange.height)) {
                    this.autoScroll();
                }
                g.setColor(backupColor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize() {
        SequenceModel model = this.getModel();
        if (model != null) {
            SequenceModel sequenceModel = model;
            synchronized (sequenceModel) {
                Dimension size = new Dimension(this.xRate * model.getObjectNum() + SequenceMapCanvas.MARGIN.left + SequenceMapCanvas.MARGIN.right, this.yRate * model.getSequenceNum() + SequenceMapCanvas.MARGIN.top + SequenceMapCanvas.MARGIN.bottom);
                this.setPreferredSize(size);
            }
        } else {
            this.setPreferredSize(new Dimension(1, 1));
        }
        this.revalidate();
        this.repaint();
    }

    public int getXRate() {
        return this.xRate;
    }

    public void setXRate(int x) {
        this.xRate = x;
    }

    public int getYRate() {
        return this.yRate;
    }

    public void setYRate(int y) {
        this.yRate = y;
    }

    public void dataChanged() {
        this.resize();
        this.revalidate();
    }

    public void selectionChanged() {
        this.repaint();
    }

    public SequenceDiagramsAdjuster getAdjuster() {
        return this.adjuster;
    }

    public void autoScroll() {
        if (this.scrollPane == null || this.adjuster == null) {
            return;
        }
        Rectangle viewRange = this.adjuster.translateCoordinates(this.adjuster.getDiagramCanvasViewRange());
        int centerX = (int)(viewRange.getX() + viewRange.getWidth() / 2.0);
        int centerY = (int)(viewRange.getY() + viewRange.getHeight() / 2.0);
        Rectangle viewPortRectangle = this.scrollPane.getViewport().getViewRect();
        if (!viewPortRectangle.contains(centerX, centerY)) {
            int viewWidth = (int)viewPortRectangle.getWidth();
            int viewHeight = (int)viewPortRectangle.getHeight();
            this.scrollPane.getHorizontalScrollBar().setValue(centerX - viewWidth / 2);
            this.scrollPane.getVerticalScrollBar().setValue(centerY - viewHeight / 2);
        }
        this.repaint();
    }

    private boolean sequenceIsSelected(int index) {
        Set selectedIndexes = this.getModel().getSelectionModel().getSelectedSequenceIndex();
        Iterator it = selectedIndexes.iterator();
        while (it.hasNext()) {
            int selectedIndex = (Integer)it.next();
            int pareIndex = this.getModel().getSequence(selectedIndex).getPareSequence().getIndex();
            if (index < selectedIndex || index > pareIndex) continue;
            return true;
        }
        Set calles = this.getModel().getSelectionModel().getSelectedCalled();
        Iterator it2 = calles.iterator();
        while (it2.hasNext()) {
            Called called = (Called)it2.next();
            if (called.getStart() > index || called.getEnd() < index) continue;
            return true;
        }
        Set objects = this.getModel().getSelectionModel().getSelectedObjectIndex();
        Iterator it3 = objects.iterator();
        while (it3.hasNext()) {
            SequenceObject object = this.getModel().getObject((Integer)it3.next());
            Sequence sequence = this.getModel().getSequence(index);
            if (sequence.getStart() != object && sequence.getEnd() != object) continue;
            return true;
        }
        Set loops = this.getModel().getSelectionModel().getSelectedLoops();
        Iterator it4 = loops.iterator();
        while (it4.hasNext()) {
            SequenceLoop loop = (SequenceLoop)it4.next();
            if (loop.getStart() > index || loop.getEnd() < index) continue;
            return true;
        }
        return false;
    }
}

