/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.library.DataChangeListener;
import amida.library.SelectionChangeListener;
import amida.sequencefilter.gui.FilterDialog;
import amida.sequencefilter.gui.ObjectFilter;
import amida.sequencer.SequenceModel;
import amida.sequencer.SequenceObject;
import amida.sequencer.gui.SequenceDiagramTabbedPane;
import amida.sequencer.gui.SequenceDiagramsAdjuster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SequenceObjectCanvas
extends JPanel
implements DataChangeListener,
SelectionChangeListener {
    public static final int DEFAULT_HEIGHT = 50;
    private static final Color selectionColor = new Color(204, 204, 255);
    private final JPopupMenu popup;
    private SequenceDiagramsAdjuster adjuster;
    private SequenceModel model;
    private int xStart;
    private int xEnd;

    public SequenceObjectCanvas() {
        this.setBackground(Color.white);
        this.popup = new JPopupMenu();
        JMenuItem filterMenuItem = new JMenuItem("Filter as...");
        this.popup.add(filterMenuItem);
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Set selectedIndex = SequenceObjectCanvas.this.model.getSelectionModel().getSelectedObjectIndex();
                if (selectedIndex.size() != 1) {
                    return;
                }
                SequenceObject object = SequenceObjectCanvas.this.model.getObject((Integer)selectedIndex.iterator().next());
                ObjectFilter filter = new ObjectFilter(SequenceDiagramTabbedPane.getInstance().getTitleAt(SequenceDiagramTabbedPane.getInstance().getSelectedIndex()), 0, object.getPackageName(), object.getClassName(), object.getIds().toString());
                FilterDialog dialog = FilterDialog.getInstance();
                dialog.setObjectFilterToSetDailog(filter);
                dialog.setSelectedTab(0);
                dialog.setVisibleOfSetDialog(0, true);
                dialog.apply();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SequenceObjectCanvas.this.adjuster == null) {
                    return;
                }
                SequenceModel model = SequenceObjectCanvas.this.getModel();
                int y = e.getY() - SequenceDiagramsAdjuster.MARGIN.top;
                if (y >= 0 && y <= SequenceDiagramsAdjuster.OBJECT_HEIGHT) {
                    int index2;
                    Rectangle viewRange = SequenceObjectCanvas.this.adjuster.getDiagramCanvasViewRange();
                    if (viewRange == null) {
                        return;
                    }
                    int objectsSpace = SequenceObjectCanvas.this.adjuster.getPreferredObjectsSpace();
                    int yStart = (int)viewRange.getY() / SequenceDiagramsAdjuster.SEQUENCE_SPACE - 1;
                    int yEnd = (int)viewRange.getHeight() / SequenceDiagramsAdjuster.SEQUENCE_SPACE + yStart;
                    int index1 = ((int)viewRange.getX() + e.getX() - SequenceDiagramsAdjuster.MARGIN.left) / (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace);
                    if (index1 == (index2 = ((int)viewRange.getX() + objectsSpace + e.getX() - SequenceDiagramsAdjuster.MARGIN.left) / (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace)) && index1 > 0 && model.getObjectNum() >= index1) {
                        SequenceObject selectedObject = model.getObject(index1 - 1);
                        if (selectedObject.isEnded(yStart)) {
                            model.getSelectionModel().clearAllSelection();
                            model.getSelectionModel().setSelectedObject(index1 - 1);
                            if (e.getButton() == 3) {
                                SequenceObjectCanvas.this.popup.show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                    } else {
                        model.getSelectionModel().clearAllSelection();
                    }
                } else {
                    model.getSelectionModel().clearAllSelection();
                }
            }
        });
    }

    public void setSequenceDiagramsAdjuster(SequenceDiagramsAdjuster adjuster) {
        this.adjuster = adjuster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        super.paint(g);
        SequenceModel model = this.getModel();
        if (model != null) {
            SequenceModel sequenceModel = model;
            synchronized (sequenceModel) {
                this.drawObjectTop(g);
            }
        }
    }

    private void drawObjectTop(Graphics g) {
        int x;
        int bottom;
        int top;
        int end;
        int start;
        SequenceModel model = this.getModel();
        if (model == null) {
            return;
        }
        int objectsSpace = this.adjuster == null ? SequenceDiagramsAdjuster.MINIMUM_OBJECTS_SPACE : this.adjuster.getPreferredObjectsSpace();
        if (this.adjuster != null) {
            Rectangle viewRange = this.adjuster.getDiagramCanvasViewRange();
            if (viewRange == null) {
                return;
            }
            start = ((int)viewRange.getX() - SequenceDiagramsAdjuster.MARGIN.left - SequenceDiagramsAdjuster.OBJECT_WIDTH) / (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace);
            end = ((int)viewRange.getX() + (int)viewRange.getWidth() - SequenceDiagramsAdjuster.MARGIN.left) / (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) - 1;
            top = (int)viewRange.getY() / SequenceDiagramsAdjuster.SEQUENCE_SPACE - 1;
            bottom = (int)viewRange.getHeight() / SequenceDiagramsAdjuster.SEQUENCE_SPACE + top + 1;
            if (start < 0) {
                start = 0;
            }
            if (end >= model.getObjectList().size()) {
                end = model.getObjectNum() - 1;
            }
            x = (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) * start + SequenceDiagramsAdjuster.MARGIN.left - (int)viewRange.getX() + 1;
        } else {
            start = this.xStart;
            end = model.getObjectNum() - 1;
            bottom = model.getSequenceNum() - 1;
            top = 0;
            x = (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) * start + SequenceDiagramsAdjuster.MARGIN.left + 1;
        }
        int fontHeight = g.getFontMetrics().getHeight();
        Set selectedSet = model.getSelectionModel().getSelectedObjectIndex();
        int i = start;
        while (i <= end) {
            SequenceObject object = model.getObject(i);
            x += SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace;
            if (object.isEnded(top)) {
                if (selectedSet.contains(new Integer(i))) {
                    Color bColor = g.getColor();
                    g.setColor(selectionColor);
                    g.fillRect(x, SequenceDiagramsAdjuster.MARGIN.top, SequenceDiagramsAdjuster.OBJECT_WIDTH, SequenceDiagramsAdjuster.OBJECT_HEIGHT);
                    g.setColor(bColor);
                }
                g.drawRect(x, SequenceDiagramsAdjuster.MARGIN.top, SequenceDiagramsAdjuster.OBJECT_WIDTH, SequenceDiagramsAdjuster.OBJECT_HEIGHT);
                String packageName = object.getPackageName();
                int line = this.drawPackageName(g, String.valueOf(packageName) + ":", x + 3, SequenceDiagramsAdjuster.MARGIN.top + fontHeight, SequenceDiagramsAdjuster.OBJECT_WIDTH - 3);
                String className = object.getClassName();
                line += this.drawClassName(g, className, x + 3, SequenceDiagramsAdjuster.MARGIN.top + fontHeight * (line + 1), SequenceDiagramsAdjuster.OBJECT_WIDTH - 3);
                int space = SequenceDiagramsAdjuster.OBJECT_HEIGHT / fontHeight - line;
                this.drawObjectId(g, object.getIds(), x + 3, SequenceDiagramsAdjuster.MARGIN.top + fontHeight * (line + 1), SequenceDiagramsAdjuster.OBJECT_WIDTH - 3, space);
            }
            ++i;
        }
    }

    private int drawPackageName(Graphics g, String text, int x, int y, int spaceWidth) {
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        if (textWidth <= spaceWidth) {
            g.drawString(text, x, y);
            return 1;
        }
        ArrayList<Integer> cutIndex = new ArrayList<Integer>();
        int i = 1;
        while (i < text.length()) {
            if (text.charAt(i) == '.') {
                cutIndex.add(new Integer(i));
            }
            ++i;
        }
        cutIndex.add(new Integer(text.length()));
        int start = 0;
        int y2 = y;
        int line = 0;
        int i2 = cutIndex.size() - 1;
        while (start < text.length()) {
            int index = (Integer)cutIndex.get(i2);
            String subText = text.substring(start, index);
            if (fm.stringWidth(subText) <= spaceWidth || i2 == 0) {
                g.drawString(subText, x, y2);
                start = index;
                y2 += fm.getHeight();
                i2 = cutIndex.size() - 1;
                ++line;
                continue;
            }
            --i2;
        }
        return line;
    }

    private int drawClassName(Graphics g, String text, int x, int y, int spaceWidth) {
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        if (textWidth <= spaceWidth) {
            g.drawString(text, x, y);
            return 1;
        }
        ArrayList<Integer> cutIndex = new ArrayList<Integer>();
        int i = 1;
        while (i < text.length()) {
            if (Character.isUpperCase(text.charAt(i)) || text.charAt(i) == '.') {
                cutIndex.add(new Integer(i));
            }
            ++i;
        }
        cutIndex.add(new Integer(text.length()));
        int start = 0;
        int y2 = y;
        int line = 0;
        int i2 = cutIndex.size() - 1;
        while (start < text.length()) {
            int index = (Integer)cutIndex.get(i2);
            String subText = text.substring(start, index);
            if (fm.stringWidth(subText) <= spaceWidth || i2 == 0) {
                g.drawString(subText, x, y2);
                start = index;
                y2 += fm.getHeight();
                i2 = cutIndex.size() - 1;
                ++line;
                continue;
            }
            --i2;
        }
        return line;
    }

    private void drawObjectId(Graphics g, Set ids, int x, int y, int spaceWidth, int maxLine) {
        FontMetrics fm = g.getFontMetrics();
        int charHeight = fm.getHeight();
        int y2 = y;
        int x2 = 0;
        int lineCount = 0;
        ArrayList list = new ArrayList(ids);
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            while (it.hasNext()) {
                Integer id = (Integer)it.next();
                String sid = id.toString();
                if (fm.stringWidth(String.valueOf(buffer.toString()) + sid) < spaceWidth) {
                    buffer.append(String.valueOf(sid) + ",");
                    continue;
                }
                it.previous();
                break;
            }
            if (buffer.length() == 0) continue;
            if (lineCount + 1 >= maxLine && it.hasNext()) {
                buffer.delete(buffer.length() - 3, buffer.length());
                buffer.append("...");
                g.drawString(buffer.toString(), x + x2, y2);
                return;
            }
            buffer.deleteCharAt(buffer.length() - 1);
            g.drawString(buffer.toString(), x + x2, y2);
            ++lineCount;
            y2 += charHeight;
        }
    }

    public SequenceModel getModel() {
        if (this.adjuster != null) {
            return this.adjuster.getModel();
        }
        return this.model;
    }

    protected void setModel(SequenceModel model) {
        this.model = model;
        model.addDataChangeListener(this);
        model.getSelectionModel().addSelectionListener(this);
        this.resize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize() {
        SequenceModel model = this.getModel();
        if (model == null) {
            return;
        }
        SequenceModel sequenceModel = model;
        synchronized (sequenceModel) {
            if (this.adjuster == null) {
                int objectSpace = SequenceDiagramsAdjuster.MINIMUM_OBJECTS_SPACE;
            } else {
                int objectSpace = this.adjuster.getPreferredObjectsSpace();
            }
            int x = this.adjuster.getDiagramCanvasViewRange().width;
            int y = 50;
            Dimension newSize = new Dimension(x, y);
            this.setPreferredSize(newSize);
        }
        this.revalidate();
        this.repaint();
    }

    public void dataChanged() {
        this.resize();
    }

    public void selectionChanged() {
        this.repaint();
    }

    public void setXRange(int start, int end) {
        this.xStart = start;
        this.xEnd = end;
    }
}

