/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.list.TIntList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.set.TIntSet;
import java.io.Serializable;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectedEdge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Group;

public class DirectedGroup
implements Serializable {
    private static final long serialVersionUID = 1922978534450625080L;
    private TIntSet gatheredFiles;
    private TIntObjectMap<TIntList> gatheredFileMap;
    private Set<DirectedEdge> gatheredEdges;

    public DirectedGroup(Group source, Set<DirectedEdge> edges) {
        this.gatheredFiles = source.gatheredFiles();
        this.gatheredFileMap = source.gatheredFileMap();
        this.gatheredEdges = edges;
    }

    public TIntSet gatheredFiles() {
        return this.gatheredFiles;
    }

    public TIntList gathered(int gatheredId) {
        return (TIntList)this.gatheredFileMap.get(gatheredId);
    }

    public Set<DirectedEdge> gatheredEdges() {
        return this.gatheredEdges;
    }

    public int choose1(int fileId) {
        return fileId < 0 ? this.gathered(fileId).iterator().next() : fileId;
    }

    public int chooseMin(int fileId) {
        return fileId < 0 ? this.gathered(fileId).get(0) : fileId;
    }

    public int chooseMax(int fileId) {
        return fileId < 0 ? this.gathered(fileId).get(this.gathered(fileId).size() - 1) : fileId;
    }
}

