/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

public class DirectoryInfo
implements Serializable {
    private static final long serialVersionUID = -3645969748302556969L;
    private int projectId;
    private URI path;
    private DirectoryInfo parent;
    private Set<DirectoryInfo> subdir;
    private TIntSet files;

    public DirectoryInfo(Path target, int projectId, DirectoryInfo parent) {
        this.projectId = projectId;
        this.path = target.toUri();
        this.subdir = new THashSet();
        this.files = new TIntHashSet();
        this.parent = parent;
    }

    public DirectoryInfo getParentDirectory() {
        return this.parent;
    }

    public synchronized boolean addFile(int fid) {
        return this.files.add(fid);
    }

    public TIntSet files() {
        return this.files;
    }

    public TIntSet allFiles() {
        TIntHashSet all = new TIntHashSet((TIntCollection)this.files);
        for (DirectoryInfo child : this.subdir) {
            all.addAll((TIntCollection)child.allFiles());
        }
        return all;
    }

    public int numberOfFiles() {
        return this.files.size();
    }

    public boolean addDirectory(DirectoryInfo child) {
        return this.subdir.add(child);
    }

    public Set<DirectoryInfo> getSubdirectories() {
        return this.subdir;
    }

    public int projectId() {
        return this.projectId;
    }

    public String getName() {
        return Paths.get(this.path).getFileName().toString();
    }

    public URI getPath() {
        return this.path;
    }
}

