/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.set.hash.THashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.util.EncodeDetector;

public class SimilarityOnDisk
implements ISimilarity,
Serializable {
    private static final long serialVersionUID = -6487655544696948519L;
    private static final int DIFFTMP_SIZE = 400;
    private URI tmp;
    private Set<Edge> edges;

    public SimilarityOnDisk(Path tmp) {
        Path simout = Paths.get(tmp.toString(), "sim");
        this.tmp = simout.toUri();
        try {
            Files.createDirectory(simout, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.edges = new THashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSimilarity(Edge edge, float similarity) {
        Set<Edge> set = this.edges;
        synchronized (set) {
            this.edges.add(edge);
        }
        Path p = this.diffPath(edge);
        Path dir = p.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(p, Charset.defaultCharset(), new OpenOption[0]);){
                bw.append(Float.toString(similarity));
                bw.append('\n');
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public float getSimilarity(Edge edge) {
        block13: {
            Path p;
            if (this.edges.contains(edge) && Files.exists(p = this.diffPath(edge), new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedReader fin = Files.newBufferedReader(p, EncodeDetector.charset(p));){
                        String line = fin.readLine();
                        if (line == null) break block13;
                        return Float.parseFloat(line);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return -2.2f;
    }

    @Override
    public void setDiff(Edge edge, String diff) {
        Path p = this.diffPath(edge);
        Path dir = p.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(p, Charset.defaultCharset(), StandardOpenOption.WRITE);){
                String diffText = diff.replaceAll("\r\n", "\n").replaceAll("[^<>].*\\n", "");
                int dec = 0;
                char[] cArray = diffText.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (c == '<') {
                        ++dec;
                    }
                    ++n2;
                }
                int inc = diffText.length() - dec;
                bw.append(String.format("dec %d\n inc %d\ndiff %d\ndiffTXT\n", dec, inc, diffText.length()));
                bw.append(diff);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getDiff(Edge edge) {
        Path p;
        if (this.edges.contains(edge) && Files.exists(p = this.diffPath(edge), new LinkOption[0])) {
            StringBuilder result = new StringBuilder();
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (BufferedReader fin = Files.newBufferedReader(p, EncodeDetector.charset(p));){
                    String line;
                    while ((line = fin.readLine()) != null) {
                        if (line.equals("diffTXT")) break;
                    }
                    while ((line = fin.readLine()) != null) {
                        result.append(line);
                        result.append('\n');
                    }
                    return result.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public int getDiffSize(Edge edge) {
        Path p;
        if (this.edges.contains(edge) && Files.exists(p = this.diffPath(edge), new LinkOption[0])) {
            try {
                for (String s : Files.readAllLines(p, EncodeDetector.charset(p))) {
                    String[] sp = s.split(" ");
                    if (!sp[0].equals("diff")) continue;
                    return Integer.parseInt(sp[1]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getDiffSize(int v, int u) {
        return this.getDiffSize(new Edge(v, u));
    }

    @Override
    public int getDec(Edge edge) {
        Path p;
        if (this.edges.contains(edge) && Files.exists(p = this.diffPath(edge), new LinkOption[0])) {
            try {
                for (String s : Files.readAllLines(p, EncodeDetector.charset(p))) {
                    String[] sp = s.split(" ");
                    if (!sp[0].equals("dec")) continue;
                    return Integer.parseInt(sp[1]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getInc(Edge edge) {
        Path p;
        if (this.edges.contains(edge) && Files.exists(p = this.diffPath(edge), new LinkOption[0])) {
            try {
                for (String s : Files.readAllLines(p, EncodeDetector.charset(p))) {
                    String[] sp = s.split(" ");
                    if (!sp[0].equals("inc")) continue;
                    return Integer.parseInt(sp[1]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void setIncDec(Edge edge, int add, int del) {
        boolean bdiff;
        boolean bdec;
        boolean binc;
        ArrayList<String> buf;
        Path p;
        block27: {
            p = this.diffPath(edge);
            Path dir = p.getParent();
            if (!Files.exists(dir, new LinkOption[0])) {
                try {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            buf = new ArrayList<String>();
            binc = false;
            bdec = false;
            bdiff = false;
            boolean bread = false;
            if (!Files.exists(p, new LinkOption[0])) break block27;
            try {
                for (String s : Files.readAllLines(p, EncodeDetector.charset(p))) {
                    block28: {
                        if (bread) break block28;
                        String[] sp = s.split(" ");
                        switch (sp[0]) {
                            case "inc": {
                                buf.add("inc " + add);
                                binc = true;
                                break;
                            }
                            case "dec": {
                                buf.add("dec " + del);
                                bdec = true;
                                break;
                            }
                            case "diff": {
                                buf.add("diff " + (add + del));
                                bdiff = true;
                                break;
                            }
                            case "diffTXT": {
                                bread = true;
                            }
                            default: {
                                buf.add(s);
                                break;
                            }
                        }
                        continue;
                    }
                    buf.add(s);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!binc) {
            buf.add("inc " + add);
        }
        if (!bdec) {
            buf.add("dec " + del);
        }
        if (!bdiff) {
            buf.add("diff " + (add + del));
        }
        try {
            Files.write(p, buf, Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int difftmpSmall(Edge edge) {
        return edge.hashCode() / 400;
    }

    private Path diffPath(Edge edge) {
        String fileName = "" + edge.fileId1() + '_' + edge.fileId2() + ".diff";
        return Paths.get(Paths.get(this.tmp).toString(), Integer.toString(this.difftmpSmall(edge)), fileName);
    }

    @Override
    public Set<Edge> edges() {
        return new THashSet(this.edges);
    }
}

