/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.util.EncodeDetector;

public class SimilarityOnMemoryDiffOnDisk
implements ISimilarity,
Serializable {
    private static final long serialVersionUID = -9022741990492017710L;
    private static final int DIFFTMP_SIZE = 400;
    private URI tmp;
    private TObjectFloatMap<Edge> sim;
    private TObjectIntMap<Edge> incm;
    private TObjectIntMap<Edge> decm;

    public SimilarityOnMemoryDiffOnDisk(Path tmp) {
        Path simout = Paths.get(tmp.toString(), "sim");
        this.tmp = simout.toUri();
        try {
            Files.createDirectory(simout, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sim = new TObjectFloatHashMap();
        this.incm = new TObjectIntHashMap();
        this.decm = new TObjectIntHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSimilarity(Edge edge, float similarity) {
        TObjectFloatMap<Edge> tObjectFloatMap = this.sim;
        synchronized (tObjectFloatMap) {
            this.sim.put((Object)edge, similarity);
        }
    }

    @Override
    public float getSimilarity(Edge edge) {
        if (this.sim.containsKey((Object)edge)) {
            return this.sim.get((Object)edge);
        }
        return -2.2f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDiff(Edge edge, String diff) {
        String diffText = diff.replaceAll("\r\n", "\n").replaceAll("[^<>].*\\n", "");
        int dec = 0;
        char[] cArray = diffText.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '<') {
                ++dec;
            }
            ++n2;
        }
        int inc = diffText.length() - dec;
        TObjectIntMap<Edge> tObjectIntMap = this.incm;
        synchronized (tObjectIntMap) {
            this.incm.put((Object)edge, inc);
        }
        tObjectIntMap = this.decm;
        synchronized (tObjectIntMap) {
            this.decm.put((Object)edge, dec);
        }
        Path p = this.diffPath(edge);
        Path dir = p.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Throwable e = null;
            Object var9_14 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(p, Charset.defaultCharset(), new OpenOption[0]);){
                bw.append(diff);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getDiff(Edge edge) {
        Path p;
        if (this.sim.containsKey((Object)edge) && Files.exists(p = this.diffPath(edge), new LinkOption[0])) {
            StringBuilder result = new StringBuilder();
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (BufferedReader fin = Files.newBufferedReader(p, EncodeDetector.charset(p));){
                    String line;
                    while ((line = fin.readLine()) != null) {
                        result.append(line);
                        result.append('\n');
                    }
                    return result.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public int getDiffSize(Edge edge) {
        if (this.sim.containsKey((Object)edge)) {
            return this.incm.get((Object)edge) + this.decm.get((Object)edge);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getDiffSize(int v, int u) {
        return this.getDiffSize(new Edge(v, u));
    }

    @Override
    public int getDec(Edge edge) {
        if (this.decm.containsKey((Object)edge)) {
            return this.decm.get((Object)edge);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getInc(Edge edge) {
        if (this.incm.containsKey((Object)edge)) {
            return this.incm.get((Object)edge);
        }
        return Integer.MIN_VALUE;
    }

    private int difftmpSmall(Edge edge) {
        return edge.hashCode() / 400;
    }

    private Path diffPath(Edge edge) {
        String fileName = "" + edge.fileId1() + '_' + edge.fileId2() + ".diff";
        return Paths.get(Paths.get(this.tmp).toString(), Integer.toString(this.difftmpSmall(edge)), fileName);
    }

    @Override
    public Set<Edge> edges() {
        return new THashSet((Collection)this.sim.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIncDec(Edge edge, int add, int del) {
        TObjectIntMap<Edge> tObjectIntMap = this.decm;
        synchronized (tObjectIntMap) {
            this.decm.put((Object)edge, del);
        }
        tObjectIntMap = this.incm;
        synchronized (tObjectIntMap) {
            this.incm.put((Object)edge, add);
        }
    }
}

