/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.ADiffCmd;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.WordReduce;
import jp.ac.osaka_u.ist.sel.pret.util.EncodeDetector;
import jp.ac.osaka_u.ist.sel.t_kanda.tkdiff.IntSED;
import jp.ac.osaka_u.ist.sel.t_kanda.tkdiff.TIntSED;

public class IntNKLCS
extends ADiffCmd {
    private List<String> sA;
    private List<String> sB;
    private WordReduce wr;

    public IntNKLCS(WordReduce wr) {
        this.wr = wr;
    }

    @Override
    public void set(Path file1, Path file2) {
        this.sA = IntNKLCS.listLines(file1);
        this.sB = IntNKLCS.listLines(file2);
        this.calc();
    }

    public void set(List<String> sA, Path file2) {
        this.sA = sA;
        this.sB = IntNKLCS.listLines(file2);
        this.calc();
    }

    @Override
    protected void calc() {
        TIntSED sed = new TIntSED();
        int diff = sed.diff(this.wr.toIntList(this.sA), this.wr.toIntList(this.sB));
        int nUnionAB2 = this.sA.size() + this.sB.size() + diff;
        int nIntersectionAB2 = this.sA.size() + this.sB.size() - diff;
        this.sim = (float)nIntersectionAB2 / (float)nUnionAB2;
        this.lcs = nIntersectionAB2 / 2;
        this.add = this.sB.size() - this.lcs;
        this.del = this.sA.size() - this.lcs;
    }

    public static List<String> listLines(Path path) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (String s : Files.readAllLines(path, EncodeDetector.charset(path))) {
                if ((s = s.replaceAll("[ \t]", "")).length() <= 0) continue;
                result.add(s);
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public void set(int[] l1, int[] l2) {
        IntSED sed = new IntSED();
        int diff = sed.diff(l1, l2);
        int nUnionAB2 = l1.length + l2.length + diff;
        int nIntersectionAB2 = l1.length + l2.length - diff;
        this.sim = (float)nIntersectionAB2 / (float)nUnionAB2;
        this.lcs = nIntersectionAB2 / 2;
        this.add = l2.length - this.lcs;
        this.del = l1.length - this.lcs;
    }
}

