/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.preprocess.c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.preprocess.Preprocessor;
import jp.ac.osaka_u.ist.sel.pret.engine.preprocess.c.CLexer;
import jp.ac.osaka_u.ist.sel.pret.util.EncodeDetector;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public class CPreprocessor
extends Preprocessor {
    public CPreprocessor(Path tmp) {
        super(tmp);
    }

    @Override
    public void preprocessForCalcSimilarity(FileInfo source) {
        Path tmpdir = Paths.get(this.tmp.toString(), source.parent().getName());
        try {
            Files.createDirectory(tmpdir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path tokenized = Paths.get(tmpdir.toString(), String.valueOf(source.fileId()) + "_t.tmp");
        CPreprocessor.readIdentifiers(Paths.get(source.path()), tokenized);
        source.preSim = tokenized.toUri();
    }

    public static int readIdentifiers(Path path, Path tokenized) {
        Charset cs = EncodeDetector.charset(path);
        ANTLRStringStream in = new ANTLRStringStream(CPreprocessor.rmc(path, cs));
        CLexer lexer = new CLexer((CharStream)in);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        tokens.getTokens();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(tokenized, cs, new OpenOption[0]);){
                for (Token t : tokens.getTokens()) {
                    if (t.getType() == 45) continue;
                    bw.write(t.getText());
                    bw.newLine();
                }
                return in.getLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return tokens.size();
        }
    }

    private static String rmc(Path path, Charset cs) {
        StringBuilder bf = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader fin = Files.newBufferedReader(path, cs);){
                String line;
                while ((line = fin.readLine()) != null) {
                    if (line.endsWith("\\")) {
                        bf.append(line.substring(0, line.length() - 1));
                        continue;
                    }
                    bf.append(line);
                    bf.append('\n');
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String r = "(\"(?:\\\\.|[^\"\\\\])*\"|'(?:\\\\.|[^'\\\\])*')|/\\*[^*]*\\*+(?:[^/*][^*]*\\*+)*/|//[^\\n]*";
        Pattern p = Pattern.compile(r);
        Matcher m = p.matcher(bf);
        return m.replaceAll("$1");
    }

    @Override
    public void preprocessForDiff(FileInfo source) {
        source.preDiff = source.preSim;
    }
}

