/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.preprocess.java;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.preprocess.Preprocessor;
import jp.ac.osaka_u.ist.sel.pret.engine.preprocess.java.JavaLexer;
import jp.ac.osaka_u.ist.sel.pret.util.EncodeDetector;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public class JavaPreprocessor
extends Preprocessor {
    public JavaPreprocessor(Path tmp) {
        super(tmp);
    }

    @Override
    public void preprocessForCalcSimilarity(FileInfo source) {
        Path tmpdir = Paths.get(this.tmp.toString(), source.parent().getName());
        try {
            Files.createDirectory(tmpdir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path tokenized = Paths.get(tmpdir.toString(), String.valueOf(source.fileId()) + "_t.tmp");
        JavaPreprocessor.readIdentifiers(Paths.get(source.path()), tokenized);
        source.preSim = tokenized.toUri();
    }

    public static int readIdentifiers(Path path, Path tokenized) {
        String encode = EncodeDetector.detect(path);
        Charset cs = encode != null && Charset.isSupported(encode) ? Charset.forName(encode) : Charset.defaultCharset();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(tokenized, cs, new OpenOption[0]);){
                ANTLRFileStream in = new ANTLRFileStream(path.toString(), encode);
                JavaLexer lexer = new JavaLexer((CharStream)in);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                for (Token t : tokens.getTokens()) {
                    if (t.getType() == 50 || t.getType() == 49 || t.getType() == 51) continue;
                    bw.append(t.getText());
                    bw.newLine();
                }
                return in.getLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void preprocessForDiff(FileInfo source) {
        source.preDiff = source.preSim;
    }
}

