/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.similarity;

import gnu.trove.map.TCharObjectMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.WordReduce;

public abstract class ASim {
    protected ISimilarity diffmap;
    protected Collection<FileInfo> files;
    protected TCharObjectMap<WordReduce> wrs;
    protected float threshold;
    private static final float SIZE_T = 0.5f;

    public ASim(ISimilarity diffmap, Collection<FileInfo> files, TCharObjectMap<WordReduce> wrs, float threshold) {
        this.diffmap = diffmap;
        this.files = files;
        this.wrs = wrs;
        this.threshold = threshold;
    }

    protected abstract void calc(Collection<FileInfo> var1);

    protected abstract void calcAll();

    protected boolean overSize(Path file1, Path file2) {
        try {
            long size1 = Files.size(file1);
            long size2 = Files.size(file2);
            return (float)size1 < (float)size2 * 0.5f || (float)size1 * 0.5f > (float)size2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

