/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.similarity;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.TKJavaDiff;

public class WordReduce
implements Serializable {
    private static final long serialVersionUID = 1323560663916209548L;
    private TObjectIntMap<String> words;
    public int nextWID = Integer.MIN_VALUE;

    public WordReduce() {
        this.words = new TObjectIntHashMap();
    }

    public void setAll(Collection<FileInfo> fis) {
        for (FileInfo fi : fis) {
            this.set(fi);
        }
    }

    public void set(FileInfo fi) {
        TIntIntHashMap ss = new TIntIntHashMap();
        for (String w : TKJavaDiff.listLines(Paths.get(fi.preSim))) {
            int id;
            if (this.words.containsKey((Object)w)) {
                id = this.words.get((Object)w);
            } else {
                this.words.put((Object)w, this.nextWID);
                id = this.nextWID++;
            }
            if (ss.increment(id)) continue;
            ss.put(id, 1);
        }
        fi.setFreq((TIntIntMap)ss);
    }

    public float maxSim(FileInfo fi1, FileInfo fi2) {
        TIntIntMap tf1 = fi1.getFreq();
        TIntIntMap tf2 = fi2.getFreq();
        int a = 0;
        int b = 0;
        int ab = 0;
        TIntHashSet targetWIDs = new TIntHashSet((TIntCollection)tf1.keySet());
        targetWIDs.addAll((TIntCollection)tf2.keySet());
        for (int wid : targetWIDs) {
            int tfa = tf1.get(wid);
            int tfb = tf2.get(wid);
            a += tfa;
            b += tfb;
            ab += Math.min(tfa, tfb);
        }
        return (float)ab / (float)(a + b - ab);
    }

    public TIntList toIntList(List<String> src) {
        TIntArrayList result = new TIntArrayList();
        for (String w : src) {
            result.add(this.words.get((Object)w));
        }
        return result;
    }

    public int[] toIntArray(List<String> src) {
        int[] result = new int[src.size()];
        int i = 0;
        while (i < src.size()) {
            result[i] = this.words.get((Object)src.get(i));
            ++i;
        }
        return result;
    }
}

