/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.evotree;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.THashSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.pret.engine.Target;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectedEdge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectedGroup;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Group;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.graph.Dot;
import jp.ac.osaka_u.ist.sel.pret.engine.graph.SpanningTree;
import jp.ac.osaka_u.ist.sel.pret.evotree.Counter;
import jp.ac.osaka_u.ist.sel.pret.evotree.DummysForApp;

public class Counter1
extends Counter {
    private TIntSet projects;
    private TObjectIntMap<Edge> count = new TObjectIntHashMap();
    private TObjectIntMap<Edge> incCount = new TObjectIntHashMap();
    private TObjectIntMap<Edge> decCount = new TObjectIntHashMap();

    public Counter1(Target target, ISimilarity similarity) {
        super(target, similarity);
    }

    @Override
    public void count(float threshold) {
        Collection<FileInfo> files = this.target.getCopyOfFileSet();
        for (FileInfo fi1 : files) {
            for (FileInfo fi2 : files) {
                int p2;
                int p1;
                Edge edge;
                if (fi1.fileId() >= fi2.fileId() || !(this.similarityMap.getSimilarity(edge = new Edge(fi1.fileId(), fi2.fileId())) >= threshold) || (p1 = fi1.projectId()) == (p2 = fi2.projectId()) || this.projects != null && (!this.projects.contains(p1) || !this.projects.contains(p2))) continue;
                Edge e = new Edge(p1, p2);
                this.count.put((Object)e, this.count.get((Object)e) - 1);
                this.incCount.put((Object)e, this.incCount.get((Object)e) + this.similarityMap.getInc(edge));
                this.decCount.put((Object)e, this.decCount.get((Object)e) + this.similarityMap.getDec(edge));
            }
        }
    }

    @Override
    public Path output(Path outputdir) {
        DummysForApp dummy;
        DummysForApp dummysForApp = dummy = new DummysForApp();
        dummysForApp.getClass();
        DummysForApp.DummySimilarity s = new DummysForApp.DummySimilarity(dummysForApp, this.count);
        Group g = new Group('A');
        for (Edge e : this.count.keySet()) {
            g.addEdge(e);
        }
        g.noGather();
        Group sp = SpanningTree.getSpanningTree(g, s, false);
        THashSet de = new THashSet();
        for (Edge e : sp.edges()) {
            int bw;
            int p1 = e.fileId1();
            int p2 = e.fileId2();
            int fw = this.incCount.get((Object)e);
            if (fw > (bw = this.decCount.get((Object)e))) {
                de.add(new DirectedEdge(p1, p2));
                continue;
            }
            if (fw < bw) {
                de.add(new DirectedEdge(p2, p1));
                continue;
            }
            de.add(new DirectedEdge(p1, p2, false));
        }
        DirectedGroup directedGroup = new DirectedGroup(sp, (Set<DirectedEdge>)de);
        DummysForApp dummysForApp2 = dummy;
        dummysForApp2.getClass();
        return Dot.dot(outputdir, 1, directedGroup, new DummysForApp.Dummytarget(dummysForApp2, sp, this.target), s);
    }

    public Path output2(Path outputdir) {
        DummysForApp dummy;
        DummysForApp dummysForApp = dummy = new DummysForApp();
        dummysForApp.getClass();
        DummysForApp.DummySimilarity s = new DummysForApp.DummySimilarity(dummysForApp, this.count);
        Group g = new Group('A');
        for (Edge e : this.count.keySet()) {
            g.addEdge(e);
        }
        g.noGather();
        THashSet de = new THashSet();
        for (Edge e : g.edges()) {
            int bw;
            int p1 = e.fileId1();
            int p2 = e.fileId2();
            int fw = this.incCount.get((Object)e);
            if (fw > (bw = this.decCount.get((Object)e))) {
                de.add(new DirectedEdge(p1, p2));
                continue;
            }
            if (fw < bw) {
                de.add(new DirectedEdge(p2, p1));
                continue;
            }
            de.add(new DirectedEdge(p1, p2, false));
        }
        DirectedGroup directedGroup = new DirectedGroup(g, (Set<DirectedEdge>)de);
        DummysForApp dummysForApp2 = dummy;
        dummysForApp2.getClass();
        return Dot.dot(outputdir, 1, directedGroup, new DummysForApp.Dummytarget(dummysForApp2, g, this.target), s);
    }
}

