/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PRF<T> {
    private final Collection<T> correct;
    private Collection<T> answer;
    private Collection<T> tp;
    private Collection<T> fp;
    private Collection<T> fn;

    public PRF(Collection<T> correct) {
        this.correct = new HashSet<T>(correct);
    }

    public void setAnswer(Collection<T> answer) {
        this.answer = new HashSet<T>(answer);
        this.tp = new HashSet<T>(this.correct);
        this.tp.retainAll(answer);
        this.fp = new HashSet<T>(answer);
        this.fp.removeAll(this.correct);
        this.fn = new HashSet<T>(this.correct);
        this.fn.removeAll(answer);
    }

    public Set<T> getAnswer() {
        return new HashSet<T>(this.answer);
    }

    public Set<T> truePositiveSet() {
        return new HashSet<T>(this.tp);
    }

    public int truePositive() {
        return this.tp.size();
    }

    public Set<T> falsePositiveSet() {
        return new HashSet<T>(this.fp);
    }

    public int falsePositive() {
        return this.fp.size();
    }

    public Set<T> falseNegativeSet() {
        return new HashSet<T>(this.fn);
    }

    public int falseNegative() {
        return this.fn.size();
    }

    public double precision() {
        return (double)this.truePositive() / (double)(this.truePositive() + this.falsePositive());
    }

    public double recall() {
        return (double)this.truePositive() / (double)(this.truePositive() + this.falseNegative());
    }

    public double f() {
        return 2.0 / (1.0 / this.recall() + 1.0 / this.precision());
    }
}

