/*
 * Decompiled with CFR 0.152.
 */
package letstry;

import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.OptionContainer;
import jp.ac.osaka_u.ist.sel.pret.engine.Target;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.NKLCS;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.WordReduce;
import letstry.TKJavaDiff;

public class CheckKouka {
    static WordReduce words;

    public static void main(String[] args) {
        MyEngine engine = new MyEngine();
        engine.readProject("F:\\src\\pgsql-src\\postgresql-7.4.10");
        engine.readProject("F:\\src\\pgsql-src\\postgresql-7.3.3");
        engine.readProject("F:\\src\\pgsql-src\\postgresql-7.1.1");
        engine.readProject("F:\\src\\pgsql-src\\postgresql-8.3.11");
        engine.readProject("F:\\src\\pgsql-src\\postgresql-8.3.12");
        engine.readProject("F:\\src\\pgsql-src\\postgresql-8.3.3");
        engine.readProject("F:\\src\\pgsql-src\\postgresql-9.0.0");
    }

    public static class MyEngine {
        private Target target;

        public MyEngine() {
            String[] opt = new String[]{"-m", "skip", "--type", "type.conf", "-graph", "C:\\Program Files (x86)\\Graphviz 2.28\\bin\\dot.exe", "-tmp", "F:\\tmp_splc_cc", "-thread", "7"};
            OptionContainer options = new OptionContainer(opt);
            this.target = new Target(options);
            words = new WordReduce();
        }

        public void readProject(String path) {
            Collection<FileInfo> adddd = this.target.readProject(Paths.get(path, new String[0]));
            for (FileInfo fi : adddd) {
                words.set(fi);
            }
            System.out.println("***** " + path + " *****");
            System.out.println(adddd.size());
            int ic = 0;
            for (FileInfo fi1 : adddd) {
                System.out.print("*");
                if (++ic % 100 == 0) {
                    System.out.println();
                }
                for (FileInfo fi2 : this.target.getCopyOfFileSet()) {
                    if (fi1.fileId() <= fi2.fileId() || !(words.maxSim(fi1, fi2) > 0.9f)) continue;
                    TKJavaDiff tk = new TKJavaDiff();
                    tk.set(Paths.get(fi1.preSim), Paths.get(fi2.preSim));
                    NKLCS nk = new NKLCS();
                    nk.set(Paths.get(fi1.preSim), Paths.get(fi2.preSim));
                    if (nk.lcs() != tk.lcs()) {
                        System.out.printf("%5d,%5d %s\n", nk.lcs(), tk.lcs(), String.valueOf(fi1.fileName()) + fi2.fileName());
                    }
                    if (nk.add() != tk.add()) {
                        System.out.printf("%5d,%5d %s\n", nk.add(), tk.add(), String.valueOf(fi1.fileName()) + fi2.fileName());
                    }
                    if (nk.del() != tk.del()) {
                        System.out.printf("%5d,%5d %s\n", nk.del(), tk.del(), String.valueOf(fi1.fileName()) + fi2.fileName());
                    }
                    if (nk.similarity() == tk.similarity()) continue;
                    System.out.printf("%.5f,%.5f %s\n", Float.valueOf(nk.similarity()), Float.valueOf(tk.similarity()), String.valueOf(fi1.fileName()) + fi2.fileName());
                }
            }
            System.out.println();
            System.out.println("***** CHECKED *****");
            int i = 0;
            while (i < 3) {
                System.out.println(" *" + i);
                long ltd1 = System.currentTimeMillis();
                TKJavaDiff td = new TKJavaDiff();
                for (FileInfo fi1 : adddd) {
                    List<String> sA = TKJavaDiff.listLines(Paths.get(fi1.preSim));
                    for (FileInfo fi2 : this.target.getCopyOfFileSet()) {
                        if (fi1.fileId() <= fi2.fileId() || !(words.maxSim(fi1, fi2) >= 0.9f)) continue;
                        td.set(sA, Paths.get(fi2.preSim));
                    }
                }
                long ltd2 = System.currentTimeMillis();
                System.out.println("*T *  " + (ltd2 - ltd1));
                long ln1 = System.currentTimeMillis();
                NKLCS nk = new NKLCS();
                for (FileInfo fi1 : adddd) {
                    List<String> sA = TKJavaDiff.listLines(Paths.get(fi1.preSim));
                    for (FileInfo fi2 : this.target.getCopyOfFileSet()) {
                        if (fi1.fileId() <= fi2.fileId() || !(words.maxSim(fi1, fi2) >= 0.9f)) continue;
                        nk.set(sA, Paths.get(fi2.preSim));
                    }
                }
                long ln2 = System.currentTimeMillis();
                System.out.println("*N *  " + (ln2 - ln1));
                ++i;
            }
        }
    }
}

