//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.evotree;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TObjectCharMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectCharHashMap;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Set;

import jp.ac.osaka_u.ist.sel.pret.OptionContainer;
import jp.ac.osaka_u.ist.sel.pret.engine.Target;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Group;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

/**
 * Dummy classes for drawing graph of applications, since Dot.java is designed
 * for graph of files.
 * 
 * @author t-kanda
 * 
 */
public class DummysForApp {
	public class DummySimilarity implements ISimilarity {

		TObjectIntMap<Edge> distance;

		public DummySimilarity(TObjectIntMap<Edge> distance) {
			this.distance = distance;
		}

		@Override
		public float getSimilarity(Edge edge) {
			return 0;
		}

		@Override
		public void setSimilarity(Edge edge, float similarity) {

		}

		@Override
		public void setDiff(Edge edge, String diff) {
		}

		@Override
		public Set<Edge> edges() {
			return null;
		}

		@Override
		public String getDiff(Edge edge) {
			return null;
		}

		@Override
		public int getDiffSize(Edge edge) {
			return distance.get(edge);
		}

		@Override
		public int getDiffSize(int v, int u) {
			return getDiffSize(new Edge(v, u));
		}

		@Override
		public int getDec(Edge edge) {
			return 0;
		}

		@Override
		public int getInc(Edge edge) {
			return 0;
		}

		@Override
		public void setIncDec(Edge edge, int add, int del) {
			// TODO Auto-generated method stub

		}
	}

	protected class Dummytarget extends Target {

		private static final long serialVersionUID = -3033116907966483064L;

		protected Dummytarget(Group g) {
			super(new DummyOptions());
			for (TIntIterator it = g.files().iterator(); it.hasNext();) {
				int pid = it.next();
				files.put(pid, new DummyFileInfo(pid));
			}
		}

		protected Dummytarget(Group g, Target target) {
			super(new DummyOptions());
			for (TIntIterator it = g.files().iterator(); it.hasNext();) {
				int pid = it.next();
				files.put(pid, new DummyFileInfo2(pid, target.getProjectPath(pid)));
			}
		}
	}

	private class DummyOptions extends OptionContainer {

		public DummyOptions() {
			super(new String[] { "-tmp", ".", "-type", "", "-thread", Integer.toString(ParaRun.para) });
		}

		public TObjectCharMap<String> types() {
			return new TObjectCharHashMap<>();
		}

	}

	protected class DummyFileInfo extends FileInfo {

		private static final long serialVersionUID = 3495802577136450602L;

		public DummyFileInfo(int projectId) {
			super(projectId, projectId, null, null, '0');
		}

		@Override
		public String fileName() {
			return Integer.toString(projectId());
		}

	}

	protected class DummyFileInfo2 extends FileInfo {

		private static final long serialVersionUID = 3495802577136450602L;
		private String pName;

		public DummyFileInfo2(int projectId, URI path) {
			super(projectId, projectId, null, null, '0');
			this.pName = Paths.get(path).toString();
		}

		@Override
		public String fileName() {
			return pName;
		}

	}
}
