//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class Graphviz {

	/*
	 * output formats
	 */
	public final static String T_PNG = "-Tpng";
	public final static String T_PS = "-Tps";
	public final static String T_SVG = "-Tsvg";

	/*
	 * layout
	 */
	public final static String LAYOUT_DOT = "-Kdot";
	public final static String LAYOUT_TWOPI = "-Ktwopi";
	public final static String LAYOUT_FDP = "-Kfdp";
	public final static String LAYOUT_CIRCO = "-Kcirco";
	public static final String LAYOUT_NEATO = "-Kneato";

	private Path command;

	public Graphviz(Path path) {
		command = path;
	}

	/**
	 * run dot command (png image, dot layout)
	 * 
	 * @param dot
	 *            .dot file
	 * @param outputDir
	 *            output dir
	 * @return
	 */
	public int graphViz(Path dot, Path outputDir) {
		return graphViz(dot, outputDir, T_PNG, LAYOUT_DOT);
	}

	/**
	 * run dot command
	 * 
	 * @param dot
	 *            .dot file
	 * @param outputDir
	 *            output dir
	 * @param format
	 *            picture image format
	 * @param layout
	 *            layout
	 * @return
	 */
	public int graphViz(Path dot, Path outputDir, String format, String layout) {

		String extension = format.substring(format.indexOf('T') + 1);

		try {
			List<String> args = new ArrayList<String>();
			args.add(command.toAbsolutePath().toString());
			args.add(format);
			args.add(layout);
			args.add(dot.toAbsolutePath().toString());
			args.add("-o");

			StringBuilder outputFile = new StringBuilder();
			String filename = dot.getFileName().toString();
			outputFile.append(filename.substring(0, filename.lastIndexOf('.')));
			outputFile.append('.');
			outputFile.append(extension);

			args.add(Paths.get(outputDir.toString(), outputFile.toString()).toString());

			ProcessBuilder pb = new ProcessBuilder(args);
			Process p = pb.start();
			return p.waitFor();

		} catch (IOException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return 1;
	}
}
