//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.Arrays;

import jp.ac.osaka_u.ist.sel.pret.engine.Engine;

public class CUIMain {

	private static Engine engine;

	/**
	 * This is a main.
	 */
	public static void main(String[] args) {

		OptionContainer options = new OptionContainer(args);
		try {
			Files.createDirectories(options.tmp());
			Files.createDirectories(options.result());
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		engine = new Engine(options, 0.9f);

		// input
		BufferedReader stdReader = new BufferedReader(new InputStreamReader(System.in));
		String line;

		try {
			while (true) {
				System.out.print("INPUT:");
				line = stdReader.readLine();

				long l1 = System.currentTimeMillis();
				String[] state = line.split(" ");
				switch (state[0]) {
				case "exit":
					return;
				case "read":
					com_read(Arrays.copyOfRange(state, 1, state.length));
					break;
				case "diff":
					com_diff();
					break;
				case "count":
					com_count();
					break;
				case "threshold":
					if (state.length > 1) {
						com_reset_threshold(state[1]);
					} else {
						System.out.println("Usage: threshold NEW_THRESHOLD(0.0 .. 1.0)");
					}
					break;
				case "load":
					com_load();
					break;
				}

				long l2 = System.currentTimeMillis();
				System.out.println((l2 - l1) + "m sec");
			}
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ArrayIndexOutOfBoundsException e) {
			e.printStackTrace();
		}

	}

	private static void com_count() {
		engine.count();
	}

	private static void com_diff() {
		engine.calcDiff();
		engine.saveTarget();
	}

	private static void com_read(String[] argv) {
		for (String path : argv) {
			engine.readProjectDirectory(path);
			engine.saveTarget();
		}
	}

	private static void com_reset_threshold(String newThewshold) {
		try {
			float threshold = Float.parseFloat(newThewshold);
			if (threshold >= 0f && threshold <= 1f) {
				engine.resetThreshold(Float.parseFloat(newThewshold));
			} else {
				System.out.println("Usage: threshold NEW_THRESHOLD(0.0 .. 1.0)");
			}
		} catch (NumberFormatException e) {
			System.out.println("Usage: threshold NEW_THRESHOLD(0.0 .. 1.0)");
		}
	}

	private static void com_load() {
		engine.loadTarget();
	}

}
