//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;

import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

public class DiffTKJavaDiff extends ADiff {

	public DiffTKJavaDiff(ISimilarity similarity, float threshold) {
		super(similarity, threshold);
	}

	public void calcAll(Collection<FileInfo> files) {
		ParaRun<Calc> para = new ParaRun<>();

		for (FileInfo fi : files) {
			para.add(new Calc(fi, files));
		}

		para.run2();
	}

	private class Calc implements Runnable {

		private FileInfo target;
		private Collection<FileInfo> others;

		public Calc(FileInfo target, Collection<FileInfo> others) {
			this.target = target;
			this.others = others;
		}

		@Override
		public void run() {
			TKJavaDiff diff = new TKJavaDiff();

			Path file1 = Paths.get(target.preSim);
			char file1type = target.type();
			List<String> sA = TKJavaDiff.listLines(file1);
			int f1id = target.fileId();

			for (FileInfo other : others) {
				int f2id = other.fileId();
				if (f1id > f2id && file1type == other.type()) {
					Path file2 = Paths.get(other.preSim);
					Edge edge = new Edge(target.fileId(), other.fileId());
					if (similarity.getSimilarity(edge) >= threshold && similarity.getDiff(edge) == null) {
						Path f1, f2;
						List<String> s1, s2;
						if (target.fileId() < other.fileId()) {
							f1 = file1;
							f2 = file2;
							s1 = sA;
							s2 = TKJavaDiff.listLines(file2);
						} else {
							f1 = file2;
							f2 = file1;
							s1 = TKJavaDiff.listLines(file2);
							s2 = sA;
						}
						String d = diff.diff(f1, s1, f2, s2);
						synchronized (similarity) {
							similarity.setDiff(edge, d);
						}
					}
				}
			}
		}
	}

}
