//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import jp.ac.osaka_u.ist.sel.pret.engine.data.Group;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

/**
 * Calc minimum spanning tree for each graph
 * 
 * @author t-kanda
 * 
 */
public class CalcSpanningTree {

	private ISimilarity similarity;
	private Group[] sp;

	public CalcSpanningTree(ISimilarity similarity, List<Group> groups) {
		this.similarity = similarity;
		this.sp = new Group[groups.size()];

		ParaRun<CalcSp> para = new ParaRun<>();

		for (int i = 0; i < groups.size(); i++) {
			para.add(new CalcSp(sp, groups.get(i), i));
		}

		para.run();
	}

	private class CalcSp implements Runnable {

		int i;
		Group g, sp[];

		private CalcSp(Group sp[], Group g, int i) {
			this.i = i;
			this.g = g;
			this.sp = sp;
		}

		@Override
		public void run() {

			if (g.files().size() <= 1) {
				return;
			}

			sp[i] = SpanningTree.getSpanningTree(g, similarity, true);

		}
	}

	public List<Group> result() {
		return new ArrayList<>(Arrays.asList(sp));
	}

}
