package jp.ac.osaka_u.ist.sel.pret.engine.similarity;

import gnu.trove.map.TCharObjectMap;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.CygwinDiff;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.ADiffCmd;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

public class SimCygwinDiffWR extends ASim {

	private String command;

	public SimCygwinDiffWR(ISimilarity diffmap, Collection<FileInfo> files, String diffCmd, TCharObjectMap<WordReduce> wrs, float threshold) {
		super(diffmap, files, wrs, threshold);
		this.command = diffCmd;
	}

	protected void calc(Collection<FileInfo> addedFiles) {
		ParaRun<Calc> para = new ParaRun<>();

		for (FileInfo fii : addedFiles) {
			para.add(new Calc(fii, files));
		}

		para.run2();
		return;
	}

	protected void calcAll() {
		ParaRun<Calc> para = new ParaRun<>();

		for (FileInfo fi : files) {
			para.add(new Calc(fi, files));
		}

		para.run2();
	}

	private class Calc implements Runnable {

		private FileInfo target;
		private Collection<FileInfo> others;

		public Calc(FileInfo target, Collection<FileInfo> others) {
			this.target = target;
			this.others = others;
		}

		@Override
		public void run() {

			ADiffCmd diff = new CygwinDiff(command);

			Path file1 = Paths.get(target.preSim);
			int f1id = target.fileId();
			char file1type = target.type();
			int file1FileId = target.fileId();
			boolean pre = target.preSim.equals(target.preDiff);

			for (FileInfo other : others) {
				int f2id = other.fileId();
				if (f1id > f2id && file1type == other.type() && target.projectId() != other.projectId()) {
					Edge edge = new Edge(file1FileId, other.fileId());
					Path file2 = Paths.get(other.preSim);
					if (!overSize(file1, file2) && diffmap.getSimilarity(edge) == ISimilarity.NOVALUE && wrs.get(file1type).maxSim(target, other) >= threshold) {
						diff.set(file1, file2);
						synchronized (diffmap) {
							diffmap.setSimilarity(edge, diff.similarity());
						}
						if (pre && other.preSim.equals(other.preDiff)) {
							synchronized (diffmap) {
								// edge(v1,v2) is defined as v1.id < v2.id.
								// f1.id > f2.id here so we exchange add and
								// del
								diffmap.setIncDec(edge, diff.del(), diff.add());
							}
						}
					}
				}
			}
		}
	}

}
