//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.evotree;

import gnu.trove.set.TIntSet;

import java.nio.file.Path;

import jp.ac.osaka_u.ist.sel.pret.engine.Target;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;

public abstract class Counter {

	protected Target target;
	protected ISimilarity similarityMap;
	protected TIntSet projects;

	/**
	 * get data for calculating cost
	 * 
	 * @param target
	 * @param similarity
	 */
	public Counter(Target target, ISimilarity similarity) {
		this.target = target;
		this.similarityMap = similarity;
	}

	/**
	 * get data for calculating cost, specific projects
	 * 
	 * @param target
	 * @param similarity
	 * @param projects
	 */
	public Counter(Target target, ISimilarity similarity, TIntSet projects) {
		this.target = target;
		this.similarityMap = similarity;
		this.projects = projects;
	}

	/**
	 * count cost between applications
	 * 
	 * @param threshold
	 */
	public abstract void count(float threshold);

	/**
	 * create graph(or tree) with the cost
	 * 
	 * @param outputdir
	 * @return
	 */
	public abstract Path output(Path outputdir);
}
