//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ParaRun<E extends Runnable> {

	public static int para = 1;

	private List<E> runList;

	public ParaRun() {
		runList = new LinkedList<E>();
	}

	public boolean add(E process) {
		return runList.add(process);
	}

	public boolean addAll(Collection<E> process) {
		return runList.addAll(process);
	}

	public void clear() {
		runList.clear();
	}

	/**
	 * FIFO
	 */
	public void run() {
		// int core = Runtime.getRuntime().availableProcessors();
		// int para = core * 3 - 1;
		// int para = core * 2 - 1;
		// int para = 1;
		BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(para);
		ThreadPoolExecutor exec = new ThreadPoolExecutor(para, para, 20, TimeUnit.MILLISECONDS, queue);
		int display = 0;

		try {
			System.out.println("total:" + runList.size());

			for (int i = 0; i < runList.size();) {
				if (queue.remainingCapacity() > 0) {
					exec.execute(runList.get(i));
					i++;
				} else {
					if (display > 6000) {
						System.out.println("tasks:" + exec.getTaskCount());
						display = 0;
					}
					Thread.sleep(8);
					display++;
				}
			}
		} catch (InterruptedException e) {
			throw new RuntimeException(e);
		} finally {
			exec.shutdown();
		}

		// wait for
		while (!exec.isTerminated()) {
			if (display > 6000) {
				System.out.println("tasks:" + exec.getTaskCount());
				display = 0;
			}
			try {
				Thread.sleep(8);
				display++;
			} catch (InterruptedException e) {
				throw new RuntimeException(e);
			}
		}
		System.out.println("finished.");
	}

	/**
	 * FILO
	 */
	public void run2() {
		// int core = Runtime.getRuntime().availableProcessors();
		// int para = core * 3 - 1;
		// int para = core * 2 - 1;
		// int para = 1;
		BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(para);
		ThreadPoolExecutor exec = new ThreadPoolExecutor(para, para, 20, TimeUnit.MILLISECONDS, queue);
		int display = 0;
		try {
			System.out.println("total:" + runList.size());

			for (int i = runList.size() - 1; i >= 0;) {
				if (queue.remainingCapacity() > 0) {
					exec.execute(runList.get(i));
					i--;
				} else {
					if (display > 6000) {
						System.out.println("tasks:" + exec.getTaskCount());
						display = 0;
					}
					Thread.sleep(8);
					display++;
				}
			}
		} catch (InterruptedException e) {
			throw new RuntimeException(e);
		} finally {
			exec.shutdown();
		}

		// wait for
		while (!exec.isTerminated()) {
			if (display > 6000) {
				System.out.println("tasks:" + exec.getTaskCount());
				display = 0;
			}
			try {
				Thread.sleep(8);
				display++;
			} catch (InterruptedException e) {
				throw new RuntimeException(e);
			}
		}
		System.out.println("finished.");
	}

	public int size() {
		return runList.size();
	}

}
