//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Save {
	private Path tmp;

	public Save(Path path) {
		tmp = Paths.get(path.toString(), "saved");
		try {
			Files.createDirectory(tmp);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			// e.printStackTrace();
		}

	}

	public boolean saveObject(Object obj, String code) {
		Path output = Paths.get(tmp.toString(), code);
		if (obj == null || !(obj instanceof Serializable)) {
			System.err.println("CANNOT SAVE " + code);
			return false;
		}
		try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(output))) {
			oos.writeObject(obj);
		} catch (IOException e) {
			e.printStackTrace();
			System.err.println("CANNOT SAVE TO FILE " + output);
			return false;
		}
		return true;
	}

	public Object loadObject(String code) {
		Path input = Paths.get(tmp.toString(), code);
		Object result = null;
		try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(input))) {
			result = ois.readObject();
		} catch (IOException e) {
			System.err.println("IO ERROR " + input);
			return null;
		} catch (ClassNotFoundException e) {
			System.err.println("CLASS NOT FOUND");
			return null;
		}
		return result;
	}
}
