//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.list.TIntList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.set.TIntSet;

import java.io.Serializable;
import java.util.Set;

/**
 * directed graph
 * 
 * @author t-kanda
 * 
 */
public class DirectedGroup implements Serializable {

	private static final long serialVersionUID = 1922978534450625080L;
	private TIntSet gatheredFiles;
	private TIntObjectMap<TIntList> gatheredFileMap;
	private Set<DirectedEdge> gatheredEdges;

	public DirectedGroup(Group source, Set<DirectedEdge> edges) {
		this.gatheredFiles = source.gatheredFiles();
		this.gatheredFileMap = source.gatheredFileMap();
		this.gatheredEdges = edges;
	}

	/**
	 * @return Set of file IDs
	 */
	public TIntSet gatheredFiles() {
		return gatheredFiles;
	}

	/**
	 * @param gather
	 * @return return gathered file IDs
	 */
	public TIntList gathered(int gatheredId) {
		return gatheredFileMap.get(gatheredId);
	}

	/**
	 * @return returns edge set
	 */
	public Set<DirectedEdge> gatheredEdges() {
		return gatheredEdges;
	}

	public int choose1(int fileId) {
		return fileId < 0 ? gathered(fileId).iterator().next() : fileId;
	}

	public int chooseMin(int fileId) {
		return fileId < 0 ? gathered(fileId).get(0) : fileId;
	}

	public int chooseMax(int fileId) {
		return fileId < 0 ? gathered(fileId).get(gathered(fileId).size() - 1) : fileId;
	}

}
