//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.data;

import java.io.Serializable;

/**
 * connecting two files (or projects) WITHOUT direction<br>
 * note: <code>new Edge(1,2)</code> and <code>new Edge(2,1)</code> express the same edge
 * 
 * @author t-kanda
 * 
 */
public class Edge implements Serializable {

	private static final long serialVersionUID = 1919807023155838576L;
	private int fileId1;
	private int fileId2;

	/**
	 * create undirected edge
	 * 
	 * @param fileIdA
	 * @param fileIdB
	 */
	public Edge(int fileIdA, int fileIdB) {
		fileId1 = Math.min(fileIdA, fileIdB);
		fileId2 = Math.max(fileIdA, fileIdB);
	}

	/** 
	 * @return file ID (small)
	 */
	public int fileId1() {
		return fileId1;
	}

	/**
	 * @return file ID (large)
	 */
	public int fileId2() {
		return fileId2;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof Edge)) {
			return false;
		}
		Edge target = (Edge) obj;
		return this.fileId1 == target.fileId1 && this.fileId2 == target.fileId2;
	}

	@Override
	public int hashCode() {
		return fileId1 + fileId2 * 43;
	}

	@Override
	public String toString() {
		return fileId1 + "-" + fileId2;
	}

	public boolean contains(int fileId) {
		return fileId == fileId1 || fileId == fileId2;
	}

	public int another(int fileId) {
		if (fileId == fileId1) {
			return fileId2;
		} else if (fileId == fileId2) {
			return fileId1;
		} else {
			return Integer.MIN_VALUE;
		}
	}
}
