//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.map.TIntIntMap;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;

/**
 * File Information<br><br>
 * ID, path to source, path to preprocessed file
 * 
 * @author t-kanda
 * 
 */
public class FileInfo implements Serializable {
	private static final long serialVersionUID = -8062577023609813802L;
	private int fileId;
	private int projectId;
	private URI path;
	private char type;
	private DirectoryInfo parent;
	public URI preSim, preDiff;
	private TIntIntMap freq;

	/**
	 * create. please tell me id and path
	 * 
	 * @param fileId
	 * @param projectId
	 * @param uri source file path
	 */
	public FileInfo(int fileId, int projectId, URI uri, DirectoryInfo parent, char type) {
		this.fileId = fileId;
		this.projectId = projectId;
		this.path = uri;
		this.type = type;
		this.parent = parent;
		if (parent != null) {
			parent.addFile(fileId);
		}
		preSim = this.path;
		preDiff = this.path;
	}

	/**
	 * @return@FileID
	 */
	public int fileId() {
		return fileId;
	}

	/**
	 * @return path to source
	 */
	public URI path() {
		return path;
	}

	public int projectId() {
		return projectId;
	}

	public String toString() {
		return fileId + ':' + fileName();
	}

	public String fileName() {
		return Paths.get(path).getFileName().toString();
	}

	public char type() {
		return type;
	}

	public DirectoryInfo parent() {
		return parent;
	}

	public TIntIntMap getFreq() {
		return freq;
	}

	public void setFreq(TIntIntMap freq) {
		this.freq = freq;
	}
	
}
