//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.similarity;

import gnu.trove.map.TCharObjectMap;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;

import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;

public abstract class ASim {

	protected ISimilarity diffmap;
	protected Collection<FileInfo> files;
	protected TCharObjectMap<WordReduce> wrs;
	protected float threshold;
	private static final float SIZE_T = 0.5f;

	public ASim(ISimilarity diffmap, Collection<FileInfo> files, TCharObjectMap<WordReduce> wrs, float threshold) {
		this.diffmap = diffmap;
		this.files = files;
		this.wrs = wrs;
		this.threshold = threshold;
	}

	protected abstract void calc(Collection<FileInfo> addedFiles);

	protected abstract void calcAll();

	/**
	 * file size shows that these files are unlikely similar
	 */
	protected boolean overSize(Path file1, Path file2) {
		try {
			long size1 = Files.size(file1);
			long size2 = Files.size(file2);

			return size1 < size2 * SIZE_T || size1 * SIZE_T > size2;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return false;
	}
}
