/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import jp.ac.osaka_u.ist.sel.pret.OptionContainer;
import jp.ac.osaka_u.ist.sel.pret.engine.Engine;

public class CUIMain {
    private static Engine engine;

    public static void main(String[] args) {
        OptionContainer options = new OptionContainer(args);
        try {
            Files.createDirectories(options.tmp(), new FileAttribute[0]);
            Files.createDirectories(options.result(), new FileAttribute[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        engine = new Engine(options, 0.9f);
        BufferedReader stdReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                System.out.print("INPUT:");
                String line = stdReader.readLine();
                long l1 = System.currentTimeMillis();
                String[] state = line.split(" ");
                switch (state[0]) {
                    case "exit": {
                        return;
                    }
                    case "read": {
                        CUIMain.com_read(Arrays.copyOfRange(state, 1, state.length));
                        break;
                    }
                    case "diff": {
                        CUIMain.com_diff();
                        break;
                    }
                    case "count": {
                        CUIMain.com_count();
                        break;
                    }
                    case "threshold": {
                        if (state.length > 1) {
                            CUIMain.com_reset_threshold(state[1]);
                            break;
                        }
                        System.out.println("Usage: threshold NEW_THRESHOLD(0.0 .. 1.0)");
                        break;
                    }
                    case "load": {
                        CUIMain.com_load();
                    }
                }
                long l2 = System.currentTimeMillis();
                System.out.println(String.valueOf(l2 - l1) + "m sec");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private static void com_count() {
        engine.count();
    }

    private static void com_diff() {
        engine.calcDiff();
        engine.saveTarget();
    }

    private static void com_read(String[] argv) {
        String[] stringArray = argv;
        int n = argv.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            engine.readProjectDirectory(path);
            engine.saveTarget();
            ++n2;
        }
    }

    private static void com_reset_threshold(String newThewshold) {
        try {
            float threshold = Float.parseFloat(newThewshold);
            if (threshold >= 0.0f && threshold <= 1.0f) {
                engine.resetThreshold(Float.parseFloat(newThewshold));
            } else {
                System.out.println("Usage: threshold NEW_THRESHOLD(0.0 .. 1.0)");
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Usage: threshold NEW_THRESHOLD(0.0 .. 1.0)");
        }
    }

    private static void com_load() {
        engine.loadTarget();
    }
}

