/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectCharMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.OptionContainer;
import jp.ac.osaka_u.ist.sel.pret.engine.FileInfoMaker;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectoryInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;

public class Target
implements Serializable {
    private static final long serialVersionUID = 6981720218469796287L;
    private int nextFileId = 1;
    private int nextProjectId = 1;
    protected TIntObjectMap<FileInfo> files = new TIntObjectHashMap();
    private TIntObjectMap<DirectoryInfo> projects = new TIntObjectHashMap();
    private URI tmp;
    private TObjectCharMap<String> types;

    public Target(OptionContainer options) {
        this.types = options.types();
        this.tmp = options.tmp().toUri();
    }

    private Collection<FileInfo> afterReadProject(TIntObjectMap<FileInfo> newFiles, DirectoryInfo d) {
        this.files.putAll(newFiles);
        this.projects.put(this.nextProjectId, (Object)d);
        ++this.nextProjectId;
        this.nextFileId += newFiles.size();
        return newFiles.valueCollection();
    }

    public Collection<FileInfo> readProject(Path root) {
        Path projectTmp = Paths.get(Paths.get(this.tmp).toString(), Integer.toString(this.nextProjectId));
        try {
            Files.createDirectory(projectTmp, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileInfoMaker targets = new FileInfoMaker(this.nextProjectId, this.nextFileId, projectTmp);
        DirectoryInfo d = this.read(root, targets, null);
        TIntObjectMap<FileInfo> newFiles = targets.make();
        if (d == null) {
            d = new DirectoryInfo(root, this.nextProjectId, null);
            TIntIterator it = newFiles.keySet().iterator();
            while (it.hasNext()) {
                d.addFile(it.next());
            }
        }
        return this.afterReadProject(newFiles, d);
    }

    private DirectoryInfo read(Path target, FileInfoMaker targets, DirectoryInfo parent) {
        String type;
        if (Files.isDirectory(target, new LinkOption[0])) {
            DirectoryInfo dir = new DirectoryInfo(target, this.nextProjectId, parent);
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (DirectoryStream<Path> dirs = Files.newDirectoryStream(target);){
                    for (Path p : dirs) {
                        DirectoryInfo child = this.read(p, targets, dir);
                        if (child == null) continue;
                        dir.addDirectory(child);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return dir;
        }
        if (Files.isRegularFile(target, new LinkOption[0]) && this.types.containsKey((Object)(type = this.type(target.getFileName())))) {
            targets.add(target, parent, this.types.get((Object)type));
        }
        return null;
    }

    public Collection<FileInfo> readProjectByList(Path list) {
        Path projectTmp = Paths.get(this.tmp.toString(), Integer.toString(this.nextProjectId));
        FileInfoMaker targets = new FileInfoMaker(this.nextProjectId, this.nextFileId, projectTmp);
        if (Files.exists(list, new LinkOption[0])) {
            try {
                List<String> files = Files.readAllLines(list, Charset.defaultCharset());
                for (String line : files) {
                    String type = this.type(line);
                    if (!this.types.containsKey((Object)type)) continue;
                    targets.add(Paths.get(line, new String[0]), null, this.types.get((Object)type));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TIntObjectMap<FileInfo> newFiles = targets.make();
        return this.afterReadProject(newFiles, null);
    }

    private String type(Path path) {
        return this.type(path.getFileName().toString());
    }

    private String type(String fileName) {
        int point = fileName.lastIndexOf(46);
        return point < 0 ? "" : fileName.toLowerCase().substring(fileName.lastIndexOf(46) + 1);
    }

    public FileInfo getFile(int fileId) {
        return (FileInfo)this.files.get(fileId);
    }

    public Collection<FileInfo> getCopyOfFileSet() {
        return new THashSet(this.files.valueCollection());
    }

    public int numberOfFiles() {
        return this.nextFileId - 1;
    }

    public TIntSet getFileIDsInProject(int pid) {
        return ((DirectoryInfo)this.projects.get(pid)).allFiles();
    }

    public int numberOfProject() {
        return this.nextProjectId - 1;
    }

    public String getProjectName(int pid) {
        return ((DirectoryInfo)this.projects.get(pid)).getName();
    }

    public URI getProjectPath(int pid) {
        return ((DirectoryInfo)this.projects.get(pid)).getPath();
    }
}

