/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;

public class Group
implements Serializable {
    private static final long serialVersionUID = 1922978534450625080L;
    private TIntSet files = new TIntHashSet();
    private Set<Edge> edges = new THashSet();
    private TIntSet gatheredFiles;
    private TIntObjectMap<TIntList> gatheredFileMap;
    private Set<Edge> gatheredEdges;
    private char type;

    public Group(char type) {
        this.type = type;
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
        this.files.add(edge.fileId1());
        this.files.add(edge.fileId2());
    }

    public boolean contains(int fileId) {
        return this.files.contains(fileId);
    }

    public void addAll(Group group) {
        this.edges.addAll(group.edges);
        this.files.addAll((TIntCollection)group.files);
    }

    public TIntSet files() {
        return this.files;
    }

    public Set<Edge> edges() {
        return this.edges;
    }

    public char type() {
        return this.type;
    }

    public TIntSet gatheredFiles() {
        return this.gatheredFiles;
    }

    public TIntList gathered(int gatheredId) {
        return (TIntList)this.gatheredFileMap.get(gatheredId);
    }

    public TIntObjectMap<TIntList> gatheredFileMap() {
        return this.gatheredFileMap;
    }

    public Set<Edge> gatheredEdges() {
        return this.gatheredEdges;
    }

    public void gather(Group motherGroup, Set<Edge> newEdges) {
        this.gatheredFiles = motherGroup.gatheredFiles;
        this.gatheredFileMap = motherGroup.gatheredFileMap;
        this.gatheredEdges = newEdges;
    }

    public void gather(ISimilarity similarity) {
        this.gatheredFiles = new TIntHashSet((TIntCollection)this.files);
        this.gatheredEdges = new THashSet(this.edges);
        this.gatheredFileMap = new TIntObjectHashMap();
        THashSet sameSet = new THashSet();
        for (Edge edge : this.edges) {
            TIntHashSet n;
            if (similarity.getDiffSize(edge) != 0) continue;
            this.gatheredEdges.remove(edge);
            TIntSet same1 = null;
            TIntSet same2 = null;
            int fileId1 = edge.fileId1();
            int fileId2 = edge.fileId2();
            for (TIntSet same : sameSet) {
                if (same.contains(fileId1)) {
                    same1 = same;
                    if (same2 != null) break;
                }
                if (!same.contains(fileId2)) continue;
                same2 = same;
                if (same1 != null) break;
            }
            if (same1 != same2) {
                n = new TIntHashSet();
                if (same1 != null) {
                    n.addAll((TIntCollection)same1);
                    sameSet.remove(same1);
                } else {
                    n.add(fileId1);
                }
                if (same2 != null) {
                    n.addAll((TIntCollection)same2);
                    sameSet.remove(same2);
                } else {
                    n.add(fileId2);
                }
                sameSet.add(n);
                continue;
            }
            if (same1 != null) continue;
            n = new TIntHashSet();
            n.add(fileId1);
            n.add(fileId2);
            sameSet.add(n);
        }
        int correspondId = -1;
        TIntIntHashMap correspond = new TIntIntHashMap();
        for (TIntSet same : sameSet) {
            this.gatheredFiles.removeAll((TIntCollection)same);
            this.gatheredFiles.add(correspondId);
            for (int fileId : same) {
                correspond.put(fileId, correspondId);
            }
            TIntArrayList sameList = new TIntArrayList((TIntCollection)same);
            sameList.sort();
            this.gatheredFileMap.put(correspondId, (Object)sameList);
            --correspondId;
        }
        if (correspondId < -1) {
            THashSet newEdges = new THashSet();
            Iterator<Edge> it = this.gatheredEdges.iterator();
            while (it.hasNext()) {
                Edge edge = it.next();
                int fileId1 = edge.fileId1();
                int fileId2 = edge.fileId2();
                if (correspond.containsKey(fileId1)) {
                    fileId1 = correspond.get(fileId1);
                }
                if (correspond.containsKey(fileId2)) {
                    fileId2 = correspond.get(fileId2);
                }
                if (fileId1 >= 0 && fileId2 >= 0) continue;
                Edge newEdge = new Edge(fileId1, fileId2);
                it.remove();
                newEdges.add(newEdge);
            }
            this.gatheredEdges.addAll((Collection<Edge>)newEdges);
        }
    }

    public void noGather() {
        this.gatheredFiles = this.files;
        this.gatheredEdges = this.edges;
    }

    public int choose1(int fileId) {
        return fileId < 0 ? this.gathered(fileId).iterator().next() : fileId;
    }
}

