/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.graph;

import gnu.trove.TIntCollection;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import jp.ac.osaka_u.ist.sel.pret.engine.Target;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectedEdge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectedGroup;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;

public class Dot {
    public static final String COLOR_G = "#FFFFFF";

    private static float linewidth(int diffSize) {
        return 2.0f;
    }

    private static String fileNameSet(TIntCollection gathered, Target target) {
        StringBuilder buffer = new StringBuilder();
        for (int fid : gathered) {
            FileInfo fi = target.getFile(fid);
            buffer.append(fi.projectId());
            buffer.append(':');
            buffer.append(fi.fileName());
            buffer.append('(');
            buffer.append(fid);
            buffer.append(')');
            buffer.append("\\n");
        }
        return buffer.toString();
    }

    public static Path dot(Path output, int groupId, DirectedGroup group, Target target, ISimilarity diffmap) {
        Path tmp = Paths.get(output.toString(), String.valueOf(groupId) + ".dot");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(tmp, Charset.defaultCharset(), new OpenOption[0]);){
                Dot.graph(groupId, group, target, diffmap, bw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public static void graph(int groupId, DirectedGroup group, Target target, ISimilarity diffmap, BufferedWriter bw) throws IOException {
        bw.append("digraph GROUP_" + groupId + "{ \n");
        bw.append("overlap = scale;\n");
        for (int node : group.gatheredFiles()) {
            String label;
            if (node < 0) {
                label = Dot.fileNameSet((TIntCollection)group.gathered(node), target);
            } else {
                StringBuilder buffer = new StringBuilder();
                FileInfo fi = target.getFile(node);
                buffer.append(fi.projectId());
                buffer.append(':');
                buffer.append(fi.fileName().replaceAll("\\\\", "\\\\\\\\"));
                buffer.append('(');
                buffer.append(node);
                buffer.append(')');
                label = buffer.toString();
            }
            bw.append(String.format("%6d [style=filled, shape = box, fillcolor = \"%s\", label=\"%s\"];\n", node, COLOR_G, label));
        }
        for (DirectedEdge edge : group.gatheredEdges()) {
            int from = edge.from();
            int to = edge.to();
            Edge sample = new Edge(group.choose1(from), group.choose1(to));
            int diffSize = diffmap.getDiffSize(sample);
            String direction = edge.hasDirection() ? "" : "dir=none";
            bw.append(String.format("%d -> %d [label = \"%d\" penwidth=%.1f %s];\n", from, to, diffSize, Float.valueOf(Dot.linewidth(diffSize)), direction));
        }
        bw.append("}");
    }
}

