/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.similarity;

import gnu.trove.TCharCollection;
import gnu.trove.iterator.TCharIterator;
import gnu.trove.map.TCharObjectMap;
import gnu.trove.map.hash.TCharObjectHashMap;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.ASim;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.SimCommandDiffWR;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.SimCygwinDiffWR;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.SimNKLCSWR;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.SimTKJavaDiffWR;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.WordReduce;

public class CalcSim
implements Serializable {
    private static final long serialVersionUID = 1262327329218392225L;
    private TCharObjectMap<WordReduce> words = new TCharObjectHashMap();
    private Path diffCommand = null;
    private int diffType;
    private static final int LCS_J = 0;
    private static final int DIFF_J = 1;
    private static final int DIFF_COM = 5;
    private static final int DIFF_CYG = 6;

    public CalcSim(TCharCollection types, int diffType, Path path) {
        TCharIterator it = types.iterator();
        while (it.hasNext()) {
            this.words.put(it.next(), (Object)new WordReduce());
        }
        this.diffType = diffType;
        if (diffType >= 5) {
            if (this.diffCommand != null && Files.isExecutable(this.diffCommand)) {
                this.diffCommand = path;
            } else {
                this.diffType = 0;
            }
        }
    }

    public void calc(ISimilarity diffmap, Collection<FileInfo> addedFiles, Collection<FileInfo> files, float threshold) {
        for (FileInfo fi : addedFiles) {
            ((WordReduce)this.words.get(fi.type())).set(fi);
        }
        ASim calc = this.sim(diffmap, files, threshold);
        calc.calc(addedFiles);
    }

    public void calcAll(ISimilarity diffmap, Collection<FileInfo> files, float threshold) {
        ASim calc = this.sim(diffmap, files, threshold);
        calc.calcAll();
    }

    private ASim sim(ISimilarity diffmap, Collection<FileInfo> files, float threshold) {
        switch (this.diffType) {
            case 5: {
                return new SimCommandDiffWR(diffmap, files, this.diffCommand.toString(), this.words, threshold);
            }
            case 6: {
                return new SimCygwinDiffWR(diffmap, files, this.diffCommand.toString(), this.words, threshold);
            }
            case 1: {
                return new SimTKJavaDiffWR(diffmap, files, this.words, threshold);
            }
        }
        return new SimNKLCSWR(diffmap, files, this.words, threshold);
    }
}

