/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import jp.ac.osaka_u.ist.sel.pret.OptionContainer;
import jp.ac.osaka_u.ist.sel.pret.engine.Target;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.data.SimilarityDataFactory;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.CalcDiff;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.CalcSim;
import jp.ac.osaka_u.ist.sel.pret.evotree.Counter1;
import jp.ac.osaka_u.ist.sel.pret.util.Graphviz;
import jp.ac.osaka_u.ist.sel.pret.util.Save;

public class Engine {
    private OptionContainer options;
    private Target target;
    private CalcSim calcSim;
    private CalcDiff calcDiff;
    private ISimilarity similarity;
    private Save save;
    private float threshold;

    public Engine(OptionContainer options, float initialThreshold) {
        this.options = options;
        this.target = new Target(options);
        this.calcSim = new CalcSim(options.types().valueCollection(), options.diffType(), options.diffCommand());
        this.calcDiff = new CalcDiff(options.diffType(), options.diffCommand());
        this.similarity = SimilarityDataFactory.create(options);
        this.save = new Save(options.tmp());
        this.threshold = initialThreshold;
    }

    public void calc(Collection<FileInfo> addedFileInfo) {
        System.out.println("** CALCSIM");
        this.calcSim.calc(this.similarity, addedFileInfo, this.target.getCopyOfFileSet(), this.threshold);
    }

    public void readProjectDirectory(String path) {
        long l1 = System.currentTimeMillis();
        System.out.print("** READ ");
        System.out.println(path);
        this.calc(this.target.readProject(Paths.get(path, new String[0])));
        long l2 = System.currentTimeMillis();
        System.out.printf("%f sec\n", Float.valueOf((float)(l2 - l1) / 1000.0f));
    }

    public void readProject(String path) {
        this.readProjectDirectory(path);
    }

    public void readProjectByFileList(String path) {
        long l1 = System.currentTimeMillis();
        System.out.print("** READ ");
        System.out.println(path);
        this.calc(this.target.readProjectByList(Paths.get(path, new String[0])));
        long l2 = System.currentTimeMillis();
        System.out.printf("%f sec\n", Float.valueOf((float)(l2 - l1) / 1000.0f));
    }

    public void resetThreshold(float threshold) {
        if (this.threshold > threshold) {
            this.threshold = threshold;
            System.out.println("** CALCSIM");
            this.calcSim.calcAll(this.similarity, this.target.getCopyOfFileSet(), threshold);
            this.calcDiff();
        } else {
            this.threshold = threshold;
        }
    }

    public void calcDiff() {
    }

    public void count() {
        Counter1 ssss = new Counter1(this.target, this.similarity);
        ssss.count(this.threshold);
        Path output = Paths.get(this.options.result().toString(), String.valueOf(Float.toString(this.threshold)) + ".dot");
        Path dot = ssss.output(this.options.result());
        try {
            Files.move(dot, output, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.options.graphvizPath() != null) {
            Graphviz g = new Graphviz(this.options.graphvizPath());
            g.graphViz(output, this.options.result());
        }
    }

    public void saveTarget() {
        this.save.saveObject(this.target, "target");
        this.save.saveObject(this.calcSim, "calc");
        this.save.saveObject(this.similarity, "sim");
    }

    public void loadTarget() {
        this.target = (Target)this.save.loadObject("target");
        this.calcSim = (CalcSim)this.save.loadObject("calc");
        this.similarity = (ISimilarity)this.save.loadObject("sim");
    }

    public void printfdata(int i) {
        FileInfo fi = this.target.getFile(i);
        System.out.printf("%3d %3d %s\r\n", fi.projectId(), i, fi.path());
    }

    public void printProjects() {
        int p = this.target.numberOfProject();
        int i = 0;
        while (i < p) {
            System.out.printf("%3d %s\r\n", i, this.target.getProjectPath(i));
            ++i;
        }
    }
}

