/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.map.TIntIntMap;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectoryInfo;

public class FileInfo
implements Serializable {
    private static final long serialVersionUID = -8062577023609813802L;
    private int fileId;
    private int projectId;
    private URI path;
    private char type;
    private DirectoryInfo parent;
    public URI preSim;
    public URI preDiff;
    private TIntIntMap freq;

    public FileInfo(int fileId, int projectId, URI uri, DirectoryInfo parent, char type) {
        this.fileId = fileId;
        this.projectId = projectId;
        this.path = uri;
        this.type = type;
        this.parent = parent;
        if (parent != null) {
            parent.addFile(fileId);
        }
        this.preSim = this.path;
        this.preDiff = this.path;
    }

    public int fileId() {
        return this.fileId;
    }

    public URI path() {
        return this.path;
    }

    public int projectId() {
        return this.projectId;
    }

    public String toString() {
        return String.valueOf(this.fileId + 58) + this.fileName();
    }

    public String fileName() {
        return Paths.get(this.path).getFileName().toString();
    }

    public char type() {
        return this.type;
    }

    public DirectoryInfo parent() {
        return this.parent;
    }

    public TIntIntMap getFreq() {
        return this.freq;
    }

    public void setFreq(TIntIntMap freq) {
        this.freq = freq;
    }
}

