/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.ADiffCmd;

public class CygwinDiff
extends ADiffCmd {
    public static final int DIFF_LINE = 0;
    public static final int DIFF_TOKEN = 1;
    private static final char OLD_LINE = '-';
    private static final char NEW_LINE = '+';
    private static final char UNCHANGED_LINE = '*';
    private static final String OPTION_BASE = "-iwB";
    private static final String[] OPTIONS1 = new String[]{"-iwB", "-u"};
    private static final String[] OPTIONS2 = new String[]{"-iwB", "--old-line-format=\"-\"", "--new-line-format=\"+\"", "--unchanged-line-format=\"*\""};
    private String diffCommand;

    public CygwinDiff(String command) {
        this.diffCommand = command;
    }

    private static String cygPath(String path) {
        return path.replaceAll("\\\\", "/").replace(":", "/cygdrive/");
    }

    @Override
    protected void calc() {
        String diff = this.execDiff(this.file1, this.file2, 1);
        int nUnionAB = diff.length() - 1;
        int nIntersectionAB = 0;
        int nDel = 0;
        int nAdd = 0;
        char[] cArray = diff.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '*': {
                    ++nIntersectionAB;
                    break;
                }
                case '-': {
                    ++nDel;
                    break;
                }
                case '+': {
                    ++nAdd;
                }
            }
            ++n2;
        }
        this.sim = (float)nIntersectionAB / (float)nUnionAB;
        this.add = nAdd;
        this.del = nDel;
        this.lcs = nIntersectionAB;
    }

    public String diff(Path file1, Path file2) {
        return this.execDiff(file1, file2, 0);
    }

    private String execDiff(final Path file1, final Path file2, int option) {
        final StringBuilder buffer = new StringBuilder();
        Process p = null;
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.diffCommand);
            switch (option) {
                case 1: {
                    command.addAll(Arrays.asList(OPTIONS2));
                    break;
                }
                case 0: {
                    command.addAll(Arrays.asList(OPTIONS1));
                }
            }
            command.add(CygwinDiff.cygPath(file1.toAbsolutePath().toString()));
            command.add(CygwinDiff.cygPath(file2.toAbsolutePath().toString()));
            ProcessBuilder pb = new ProcessBuilder(command);
            p = pb.start();
            final InputStream is = p.getInputStream();
            final InputStream eis = p.getErrorStream();
            Thread outth = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                            String result;
                            while ((result = br.readLine()) != null) {
                                buffer.append(String.valueOf(result) + "\n");
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            Thread errth = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(eis));){
                            String result;
                            while ((result = br.readLine()) != null) {
                                System.err.print(file1 + " - " + file2 + ": ");
                                System.err.println(result);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            outth.start();
            errth.start();
            p.waitFor();
            outth.join();
            errth.join();
            is.close();
            eis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.err.println("WHY");
            p.destroy();
        }
        return buffer.toString();
    }
}

