/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.ADiff;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.CommandDiff;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

public class DiffCommandDiff
extends ADiff {
    private String diffCommand;

    public DiffCommandDiff(ISimilarity similarity, String diffCommand, float threshold) {
        super(similarity, threshold);
        this.diffCommand = diffCommand;
    }

    @Override
    public void calcAll(Collection<FileInfo> files) {
        ParaRun<Calc> para = new ParaRun<Calc>();
        for (FileInfo fi : files) {
            para.add(new Calc(fi, files));
        }
        para.run2();
    }

    private class Calc
    implements Runnable {
        private FileInfo target;
        private Collection<FileInfo> others;

        public Calc(FileInfo target, Collection<FileInfo> others) {
            this.target = target;
            this.others = others;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CommandDiff diff = new CommandDiff(DiffCommandDiff.this.diffCommand);
            Path file1 = Paths.get(this.target.preSim);
            char file1type = this.target.type();
            for (FileInfo other : this.others) {
                Path f2;
                Path f1;
                if (file1type != other.type()) continue;
                Path file2 = Paths.get(other.preSim);
                Edge edge = new Edge(this.target.fileId(), other.fileId());
                if (!(DiffCommandDiff.this.similarity.getSimilarity(edge) >= DiffCommandDiff.this.threshold) || DiffCommandDiff.this.similarity.getDiff(edge) != null) continue;
                if (this.target.fileId() < other.fileId()) {
                    f1 = file1;
                    f2 = file2;
                } else {
                    f1 = file2;
                    f2 = file1;
                }
                String d = diff.diff(f1, f2);
                ISimilarity iSimilarity = DiffCommandDiff.this.similarity;
                synchronized (iSimilarity) {
                    DiffCommandDiff.this.similarity.setDiff(edge, d);
                }
            }
        }
    }
}

