/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Group;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.graph.SpanningTree;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

public class CalcSpanningTree {
    private ISimilarity similarity;
    private Group[] sp;

    public CalcSpanningTree(ISimilarity similarity, List<Group> groups) {
        this.similarity = similarity;
        this.sp = new Group[groups.size()];
        ParaRun<CalcSp> para = new ParaRun<CalcSp>();
        int i = 0;
        while (i < groups.size()) {
            para.add(new CalcSp(this.sp, groups.get(i), i));
            ++i;
        }
        para.run();
    }

    public List<Group> result() {
        return new ArrayList<Group>(Arrays.asList(this.sp));
    }

    private class CalcSp
    implements Runnable {
        int i;
        Group g;
        Group[] sp;

        private CalcSp(Group[] sp, Group g, int i) {
            this.i = i;
            this.g = g;
            this.sp = sp;
        }

        @Override
        public void run() {
            if (this.g.files().size() <= 1) {
                return;
            }
            this.sp[this.i] = SpanningTree.getSpanningTree(this.g, CalcSpanningTree.this.similarity, true);
        }
    }
}

